@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table.
 * @property columnWildcard Option to add column wildcard. See Column Wildcard for more details.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property name Name of the table resource.
 * The following arguments are optional:
 */
public data class ResourceLfTagTableWithColumns(
    public val catalogId: String? = null,
    public val columnNames: List<String>? = null,
    public val columnWildcard: ResourceLfTagTableWithColumnsColumnWildcard? = null,
    public val databaseName: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.ResourceLfTagTableWithColumns): ResourceLfTagTableWithColumns = ResourceLfTagTableWithColumns(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            columnNames = javaType.columnNames().map({ args0 -> args0 }),
            columnWildcard = javaType.columnWildcard().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTableWithColumnsColumnWildcard.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseName = javaType.databaseName(),
            name = javaType.name(),
        )
    }
}
