@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.AliasRoutingConfig
import com.pulumi.aws.lambda.kotlin.outputs.AliasRoutingConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.aws.lambda.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

/**
 * Creates a Lambda function alias. Creates an alias that points to the specified Lambda function version.
 * For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html)
 * For information about function aliases, see [CreateAlias](http://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/API_CreateAlias&#46;html) and [AliasRoutingConfiguration](https://docs.aws.amazon.com/lambda/latest/dg/API_AliasRoutingConfiguration.html) in the API docs.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testLambdaAlias = new aws.lambda.Alias("test_lambda_alias", {
 *     name: "my_alias",
 *     description: "a sample description",
 *     functionName: lambdaFunctionTest.arn,
 *     functionVersion: "1",
 *     routingConfig: {
 *         additionalVersionWeights: {
 *             "2": 0.5,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_lambda_alias = aws.lambda_.Alias("test_lambda_alias",
 *     name="my_alias",
 *     description="a sample description",
 *     function_name=lambda_function_test["arn"],
 *     function_version="1",
 *     routing_config={
 *         "additional_version_weights": {
 *             "_2": 0.5,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLambdaAlias = new Aws.Lambda.Alias("test_lambda_alias", new()
 *     {
 *         Name = "my_alias",
 *         Description = "a sample description",
 *         FunctionName = lambdaFunctionTest.Arn,
 *         FunctionVersion = "1",
 *         RoutingConfig = new Aws.Lambda.Inputs.AliasRoutingConfigArgs
 *         {
 *             AdditionalVersionWeights =
 *             {
 *                 { "2", 0.5 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewAlias(ctx, "test_lambda_alias", &lambda.AliasArgs{
 * 			Name:            pulumi.String("my_alias"),
 * 			Description:     pulumi.String("a sample description"),
 * 			FunctionName:    pulumi.Any(lambdaFunctionTest.Arn),
 * 			FunctionVersion: pulumi.String("1"),
 * 			RoutingConfig: &lambda.AliasRoutingConfigArgs{
 * 				AdditionalVersionWeights: pulumi.Float64Map{
 * 					"2": pulumi.Float64(0.5),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Alias;
 * import com.pulumi.aws.lambda.AliasArgs;
 * import com.pulumi.aws.lambda.inputs.AliasRoutingConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLambdaAlias = new Alias("testLambdaAlias", AliasArgs.builder()
 *             .name("my_alias")
 *             .description("a sample description")
 *             .functionName(lambdaFunctionTest.arn())
 *             .functionVersion("1")
 *             .routingConfig(AliasRoutingConfigArgs.builder()
 *                 .additionalVersionWeights(Map.of("2", 0.5))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testLambdaAlias:
 *     type: aws:lambda:Alias
 *     name: test_lambda_alias
 *     properties:
 *       name: my_alias
 *       description: a sample description
 *       functionName: ${lambdaFunctionTest.arn}
 *       functionVersion: '1'
 *       routingConfig:
 *         additionalVersionWeights:
 *           '2': 0.5
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda Function Aliases using the `function_name/alias`. For example:
 * ```sh
 * $ pulumi import aws:lambda/alias:Alias test_lambda_alias my_test_lambda_function/my_alias
 * ```
 */
public class Alias internal constructor(
    override val javaResource: com.pulumi.aws.lambda.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    /**
     * The Amazon Resource Name (ARN) identifying your Lambda function alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the alias.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Lambda Function name or ARN.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Lambda function version for which you are creating the alias. Pattern: `(\$LATEST|[0-9]+)`.
     */
    public val functionVersion: Output<String>
        get() = javaResource.functionVersion().applyValue({ args0 -> args0 })

    /**
     * The ARN to be used for invoking Lambda Function from API Gateway - to be used in `aws.apigateway.Integration`'s `uri`
     */
    public val invokeArn: Output<String>
        get() = javaResource.invokeArn().applyValue({ args0 -> args0 })

    /**
     * Name for the alias you are creating. Pattern: `(?!^[0-9]+$)([a-zA-Z0-9-_]+)`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Lambda alias' route configuration settings. Fields documented below
     */
    public val routingConfig: Output<AliasRoutingConfig>?
        get() = javaResource.routingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(
        javaResource as
            com.pulumi.aws.lambda.Alias,
    )
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
