@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.AliasArgs.builder
import com.pulumi.aws.lambda.kotlin.inputs.AliasRoutingConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.AliasRoutingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Creates a Lambda function alias. Creates an alias that points to the specified Lambda function version.
 * For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html)
 * For information about function aliases, see [CreateAlias](http://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/API_CreateAlias&#46;html) and [AliasRoutingConfiguration](https://docs.aws.amazon.com/lambda/latest/dg/API_AliasRoutingConfiguration.html) in the API docs.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testLambdaAlias = new aws.lambda.Alias("test_lambda_alias", {
 *     name: "my_alias",
 *     description: "a sample description",
 *     functionName: lambdaFunctionTest.arn,
 *     functionVersion: "1",
 *     routingConfig: {
 *         additionalVersionWeights: {
 *             "2": 0.5,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_lambda_alias = aws.lambda_.Alias("test_lambda_alias",
 *     name="my_alias",
 *     description="a sample description",
 *     function_name=lambda_function_test["arn"],
 *     function_version="1",
 *     routing_config={
 *         "additional_version_weights": {
 *             "_2": 0.5,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLambdaAlias = new Aws.Lambda.Alias("test_lambda_alias", new()
 *     {
 *         Name = "my_alias",
 *         Description = "a sample description",
 *         FunctionName = lambdaFunctionTest.Arn,
 *         FunctionVersion = "1",
 *         RoutingConfig = new Aws.Lambda.Inputs.AliasRoutingConfigArgs
 *         {
 *             AdditionalVersionWeights =
 *             {
 *                 { "2", 0.5 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewAlias(ctx, "test_lambda_alias", &lambda.AliasArgs{
 * 			Name:            pulumi.String("my_alias"),
 * 			Description:     pulumi.String("a sample description"),
 * 			FunctionName:    pulumi.Any(lambdaFunctionTest.Arn),
 * 			FunctionVersion: pulumi.String("1"),
 * 			RoutingConfig: &lambda.AliasRoutingConfigArgs{
 * 				AdditionalVersionWeights: pulumi.Float64Map{
 * 					"2": pulumi.Float64(0.5),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Alias;
 * import com.pulumi.aws.lambda.AliasArgs;
 * import com.pulumi.aws.lambda.inputs.AliasRoutingConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLambdaAlias = new Alias("testLambdaAlias", AliasArgs.builder()
 *             .name("my_alias")
 *             .description("a sample description")
 *             .functionName(lambdaFunctionTest.arn())
 *             .functionVersion("1")
 *             .routingConfig(AliasRoutingConfigArgs.builder()
 *                 .additionalVersionWeights(Map.of("2", 0.5))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testLambdaAlias:
 *     type: aws:lambda:Alias
 *     name: test_lambda_alias
 *     properties:
 *       name: my_alias
 *       description: a sample description
 *       functionName: ${lambdaFunctionTest.arn}
 *       functionVersion: '1'
 *       routingConfig:
 *         additionalVersionWeights:
 *           '2': 0.5
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda Function Aliases using the `function_name/alias`. For example:
 * ```sh
 * $ pulumi import aws:lambda/alias:Alias test_lambda_alias my_test_lambda_function/my_alias
 * ```
 * @property description Description of the alias.
 * @property functionName Lambda Function name or ARN.
 * @property functionVersion Lambda function version for which you are creating the alias. Pattern: `(\$LATEST|[0-9]+)`.
 * @property name Name for the alias you are creating. Pattern: `(?!^[0-9]+$)([a-zA-Z0-9-_]+)`
 * @property routingConfig The Lambda alias' route configuration settings. Fields documented below
 */
public data class AliasArgs(
    public val description: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val functionVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routingConfig: Output<AliasRoutingConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.AliasArgs> {
    override fun toJava(): com.pulumi.aws.lambda.AliasArgs = com.pulumi.aws.lambda.AliasArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .functionName(functionName?.applyValue({ args0 -> args0 }))
        .functionVersion(functionVersion?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .routingConfig(routingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var functionName: Output<String>? = null

    private var functionVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var routingConfig: Output<AliasRoutingConfigArgs>? = null

    /**
     * @param value Description of the alias.
     */
    @JvmName("bdimiqatcmxumjoo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Lambda Function name or ARN.
     */
    @JvmName("onoebprdallgmuoq")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Lambda function version for which you are creating the alias. Pattern: `(\$LATEST|[0-9]+)`.
     */
    @JvmName("sfcnijpkfsafevih")
    public suspend fun functionVersion(`value`: Output<String>) {
        this.functionVersion = value
    }

    /**
     * @param value Name for the alias you are creating. Pattern: `(?!^[0-9]+$)([a-zA-Z0-9-_]+)`
     */
    @JvmName("gibrrjbhxfntljtq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Lambda alias' route configuration settings. Fields documented below
     */
    @JvmName("oodxvgymaklknajl")
    public suspend fun routingConfig(`value`: Output<AliasRoutingConfigArgs>) {
        this.routingConfig = value
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("gwvfikkpntnrkolv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Lambda Function name or ARN.
     */
    @JvmName("idnqaobintamfucj")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Lambda function version for which you are creating the alias. Pattern: `(\$LATEST|[0-9]+)`.
     */
    @JvmName("cvolyegowbsdpmhb")
    public suspend fun functionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionVersion = mapped
    }

    /**
     * @param value Name for the alias you are creating. Pattern: `(?!^[0-9]+$)([a-zA-Z0-9-_]+)`
     */
    @JvmName("kpeexakpihwnmlbk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Lambda alias' route configuration settings. Fields documented below
     */
    @JvmName("tpbiqrceeqjftrds")
    public suspend fun routingConfig(`value`: AliasRoutingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfig = mapped
    }

    /**
     * @param argument The Lambda alias' route configuration settings. Fields documented below
     */
    @JvmName("sodfywsidsqflbgj")
    public suspend fun routingConfig(argument: suspend AliasRoutingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AliasRoutingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfig = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        description = description,
        functionName = functionName,
        functionVersion = functionVersion,
        name = name,
        routingConfig = routingConfig,
    )
}
