@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.CodeSigningConfigAllowedPublishers
import com.pulumi.aws.lambda.kotlin.outputs.CodeSigningConfigPolicies
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lambda.kotlin.outputs.CodeSigningConfigAllowedPublishers.Companion.toKotlin as codeSigningConfigAllowedPublishersToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.CodeSigningConfigPolicies.Companion.toKotlin as codeSigningConfigPoliciesToKotlin

/**
 * Builder for [CodeSigningConfig].
 */
@PulumiTagMarker
public class CodeSigningConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CodeSigningConfigArgs = CodeSigningConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CodeSigningConfigArgsBuilder.() -> Unit) {
        val builder = CodeSigningConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CodeSigningConfig {
        val builtJavaResource = com.pulumi.aws.lambda.CodeSigningConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CodeSigningConfig(builtJavaResource)
    }
}

/**
 * Provides a Lambda Code Signing Config resource. A code signing configuration defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
 * For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const newCsc = new aws.lambda.CodeSigningConfig("new_csc", {
 *     allowedPublishers: {
 *         signingProfileVersionArns: [
 *             example1.arn,
 *             example2.arn,
 *         ],
 *     },
 *     policies: {
 *         untrustedArtifactOnDeployment: "Warn",
 *     },
 *     description: "My awesome code signing config.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * new_csc = aws.lambda_.CodeSigningConfig("new_csc",
 *     allowed_publishers={
 *         "signing_profile_version_arns": [
 *             example1["arn"],
 *             example2["arn"],
 *         ],
 *     },
 *     policies={
 *         "untrusted_artifact_on_deployment": "Warn",
 *     },
 *     description="My awesome code signing config.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var newCsc = new Aws.Lambda.CodeSigningConfig("new_csc", new()
 *     {
 *         AllowedPublishers = new Aws.Lambda.Inputs.CodeSigningConfigAllowedPublishersArgs
 *         {
 *             SigningProfileVersionArns = new[]
 *             {
 *                 example1.Arn,
 *                 example2.Arn,
 *             },
 *         },
 *         Policies = new Aws.Lambda.Inputs.CodeSigningConfigPoliciesArgs
 *         {
 *             UntrustedArtifactOnDeployment = "Warn",
 *         },
 *         Description = "My awesome code signing config.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewCodeSigningConfig(ctx, "new_csc", &lambda.CodeSigningConfigArgs{
 * 			AllowedPublishers: &lambda.CodeSigningConfigAllowedPublishersArgs{
 * 				SigningProfileVersionArns: pulumi.StringArray{
 * 					example1.Arn,
 * 					example2.Arn,
 * 				},
 * 			},
 * 			Policies: &lambda.CodeSigningConfigPoliciesArgs{
 * 				UntrustedArtifactOnDeployment: pulumi.String("Warn"),
 * 			},
 * 			Description: pulumi.String("My awesome code signing config."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.CodeSigningConfig;
 * import com.pulumi.aws.lambda.CodeSigningConfigArgs;
 * import com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs;
 * import com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var newCsc = new CodeSigningConfig("newCsc", CodeSigningConfigArgs.builder()
 *             .allowedPublishers(CodeSigningConfigAllowedPublishersArgs.builder()
 *                 .signingProfileVersionArns(
 *                     example1.arn(),
 *                     example2.arn())
 *                 .build())
 *             .policies(CodeSigningConfigPoliciesArgs.builder()
 *                 .untrustedArtifactOnDeployment("Warn")
 *                 .build())
 *             .description("My awesome code signing config.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   newCsc:
 *     type: aws:lambda:CodeSigningConfig
 *     name: new_csc
 *     properties:
 *       allowedPublishers:
 *         signingProfileVersionArns:
 *           - ${example1.arn}
 *           - ${example2.arn}
 *       policies:
 *         untrustedArtifactOnDeployment: Warn
 *       description: My awesome code signing config.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Code Signing Configs using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lambda/codeSigningConfig:CodeSigningConfig imported_csc arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b
 * ```
 */
public class CodeSigningConfig internal constructor(
    override val javaResource: com.pulumi.aws.lambda.CodeSigningConfig,
) : KotlinCustomResource(javaResource, CodeSigningConfigMapper) {
    /**
     * A configuration block of allowed publishers as signing profiles for this code signing configuration. Detailed below.
     */
    public val allowedPublishers: Output<CodeSigningConfigAllowedPublishers>
        get() = javaResource.allowedPublishers().applyValue({ args0 ->
            args0.let({ args0 ->
                codeSigningConfigAllowedPublishersToKotlin(args0)
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the code signing configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the code signing configuration.
     */
    public val configId: Output<String>
        get() = javaResource.configId().applyValue({ args0 -> args0 })

    /**
     * Descriptive name for this code signing configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date and time that the code signing configuration was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * A configuration block of code signing policies that define the actions to take if the validation checks fail. Detailed below.
     */
    public val policies: Output<CodeSigningConfigPolicies>
        get() = javaResource.policies().applyValue({ args0 ->
            args0.let({ args0 ->
                codeSigningConfigPoliciesToKotlin(args0)
            })
        })
}

public object CodeSigningConfigMapper : ResourceMapper<CodeSigningConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.CodeSigningConfig::class == javaResource::class

    override fun map(javaResource: Resource): CodeSigningConfig = CodeSigningConfig(
        javaResource as
            com.pulumi.aws.lambda.CodeSigningConfig,
    )
}

/**
 * @see [CodeSigningConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CodeSigningConfig].
 */
public suspend fun codeSigningConfig(
    name: String,
    block: suspend CodeSigningConfigResourceBuilder.() -> Unit,
): CodeSigningConfig {
    val builder = CodeSigningConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CodeSigningConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun codeSigningConfig(name: String): CodeSigningConfig {
    val builder = CodeSigningConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
