@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDestinationConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDocumentDbEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingFilterCriteria
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingScalingConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedEventSource
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSourceAccessConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig.Companion.toKotlin as eventSourceMappingAmazonManagedKafkaEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDestinationConfig.Companion.toKotlin as eventSourceMappingDestinationConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDocumentDbEventSourceConfig.Companion.toKotlin as eventSourceMappingDocumentDbEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingFilterCriteria.Companion.toKotlin as eventSourceMappingFilterCriteriaToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingScalingConfig.Companion.toKotlin as eventSourceMappingScalingConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedEventSource.Companion.toKotlin as eventSourceMappingSelfManagedEventSourceToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig.Companion.toKotlin as eventSourceMappingSelfManagedKafkaEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSourceAccessConfiguration.Companion.toKotlin as eventSourceMappingSourceAccessConfigurationToKotlin

/**
 * Builder for [EventSourceMapping].
 */
@PulumiTagMarker
public class EventSourceMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSourceMappingArgs = EventSourceMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSourceMappingArgsBuilder.() -> Unit) {
        val builder = EventSourceMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSourceMapping {
        val builtJavaResource = com.pulumi.aws.lambda.EventSourceMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSourceMapping(builtJavaResource)
    }
}

/**
 * Provides a Lambda event source mapping. This allows Lambda functions to get events from Kinesis, DynamoDB, SQS, Amazon MQ and Managed Streaming for Apache Kafka (MSK).
 * For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
 * For information about event source mappings, see [CreateEventSourceMapping](http://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html) in the API docs.
 * ## Example Usage
 * ### DynamoDB
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsDynamodbTable.streamArn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     startingPosition: "LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_dynamodb_table["streamArn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     starting_position="LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsDynamodbTable.StreamArn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         StartingPosition = "LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn:   pulumi.Any(exampleAwsDynamodbTable.StreamArn),
 * 			FunctionName:     pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			StartingPosition: pulumi.String("LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsDynamodbTable.streamArn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsDynamodbTable.streamArn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       startingPosition: LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Kinesis
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsKinesisStream.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     startingPosition: "LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_kinesis_stream["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     starting_position="LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsKinesisStream.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         StartingPosition = "LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn:   pulumi.Any(exampleAwsKinesisStream.Arn),
 * 			FunctionName:     pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			StartingPosition: pulumi.String("LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsKinesisStream.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsKinesisStream.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       startingPosition: LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Managed Streaming for Apache Kafka (MSK)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsMskCluster.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     topics: ["Example"],
 *     startingPosition: "TRIM_HORIZON",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_msk_cluster["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     topics=["Example"],
 *     starting_position="TRIM_HORIZON")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsMskCluster.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Topics = new[]
 *         {
 *             "Example",
 *         },
 *         StartingPosition = "TRIM_HORIZON",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(exampleAwsMskCluster.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Topics: pulumi.StringArray{
 * 				pulumi.String("Example"),
 * 			},
 * 			StartingPosition: pulumi.String("TRIM_HORIZON"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsMskCluster.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsMskCluster.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       topics:
 *         - Example
 *       startingPosition: TRIM_HORIZON
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Self Managed Apache Kafka
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     functionName: exampleAwsLambdaFunction.arn,
 *     topics: ["Example"],
 *     startingPosition: "TRIM_HORIZON",
 *     selfManagedEventSource: {
 *         endpoints: {
 *             KAFKA_BOOTSTRAP_SERVERS: "kafka1.example.com:9092,kafka2.example.com:9092",
 *         },
 *     },
 *     sourceAccessConfigurations: [
 *         {
 *             type: "VPC_SUBNET",
 *             uri: "subnet:subnet-example1",
 *         },
 *         {
 *             type: "VPC_SUBNET",
 *             uri: "subnet:subnet-example2",
 *         },
 *         {
 *             type: "VPC_SECURITY_GROUP",
 *             uri: "security_group:sg-example",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     function_name=example_aws_lambda_function["arn"],
 *     topics=["Example"],
 *     starting_position="TRIM_HORIZON",
 *     self_managed_event_source={
 *         "endpoints": {
 *             "kafk_a__bootstra_p__servers": "kafka1.example.com:9092,kafka2.example.com:9092",
 *         },
 *     },
 *     source_access_configurations=[
 *         {
 *             "type": "VPC_SUBNET",
 *             "uri": "subnet:subnet-example1",
 *         },
 *         {
 *             "type": "VPC_SUBNET",
 *             "uri": "subnet:subnet-example2",
 *         },
 *         {
 *             "type": "VPC_SECURITY_GROUP",
 *             "uri": "security_group:sg-example",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Topics = new[]
 *         {
 *             "Example",
 *         },
 *         StartingPosition = "TRIM_HORIZON",
 *         SelfManagedEventSource = new Aws.Lambda.Inputs.EventSourceMappingSelfManagedEventSourceArgs
 *         {
 *             Endpoints =
 *             {
 *                 { "KAFKA_BOOTSTRAP_SERVERS", "kafka1.example.com:9092,kafka2.example.com:9092" },
 *             },
 *         },
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SUBNET",
 *                 Uri = "subnet:subnet-example1",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SUBNET",
 *                 Uri = "subnet:subnet-example2",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SECURITY_GROUP",
 *                 Uri = "security_group:sg-example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Topics: pulumi.StringArray{
 * 				pulumi.String("Example"),
 * 			},
 * 			StartingPosition: pulumi.String("TRIM_HORIZON"),
 * 			SelfManagedEventSource: &lambda.EventSourceMappingSelfManagedEventSourceArgs{
 * 				Endpoints: pulumi.StringMap{
 * 					"KAFKA_BOOTSTRAP_SERVERS": pulumi.String("kafka1.example.com:9092,kafka2.example.com:9092"),
 * 				},
 * 			},
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SUBNET"),
 * 					Uri:  pulumi.String("subnet:subnet-example1"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SUBNET"),
 * 					Uri:  pulumi.String("subnet:subnet-example2"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SECURITY_GROUP"),
 * 					Uri:  pulumi.String("security_group:sg-example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .selfManagedEventSource(EventSourceMappingSelfManagedEventSourceArgs.builder()
 *                 .endpoints(Map.of("KAFKA_BOOTSTRAP_SERVERS", "kafka1.example.com:9092,kafka2.example.com:9092"))
 *                 .build())
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example1")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example2")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SECURITY_GROUP")
 *                     .uri("security_group:sg-example")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       topics:
 *         - Example
 *       startingPosition: TRIM_HORIZON
 *       selfManagedEventSource:
 *         endpoints:
 *           KAFKA_BOOTSTRAP_SERVERS: kafka1.example.com:9092,kafka2.example.com:9092
 *       sourceAccessConfigurations:
 *         - type: VPC_SUBNET
 *           uri: subnet:subnet-example1
 *         - type: VPC_SUBNET
 *           uri: subnet:subnet-example2
 *         - type: VPC_SECURITY_GROUP
 *           uri: security_group:sg-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### SQS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: sqsQueueTest.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=sqs_queue_test["arn"],
 *     function_name=example_aws_lambda_function["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = sqsQueueTest.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(sqsQueueTest.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(sqsQueueTest.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${sqsQueueTest.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### SQS with event filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: sqsQueueTest.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     filterCriteria: {
 *         filters: [{
 *             pattern: JSON.stringify({
 *                 body: {
 *                     Temperature: [{
 *                         numeric: [
 *                             ">",
 *                             0,
 *                             "<=",
 *                             100,
 *                         ],
 *                     }],
 *                     Location: ["New York"],
 *                 },
 *             }),
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=sqs_queue_test["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     filter_criteria={
 *         "filters": [{
 *             "pattern": json.dumps({
 *                 "body": {
 *                     "temperature": [{
 *                         "numeric": [
 *                             ">",
 *                             0,
 *                             "<=",
 *                             100,
 *                         ],
 *                     }],
 *                     "location": ["New York"],
 *                 },
 *             }),
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = sqsQueueTest.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         FilterCriteria = new Aws.Lambda.Inputs.EventSourceMappingFilterCriteriaArgs
 *         {
 *             Filters = new[]
 *             {
 *                 new Aws.Lambda.Inputs.EventSourceMappingFilterCriteriaFilterArgs
 *                 {
 *                     Pattern = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                     {
 *                         ["body"] = new Dictionary<string, object?>
 *                         {
 *                             ["Temperature"] = new[]
 *                             {
 *                                 new Dictionary<string, object?>
 *                                 {
 *                                     ["numeric"] = new object?[]
 *                                     {
 *                                         ">",
 *                                         0,
 *                                         "<=",
 *                                         100,
 *                                     },
 *                                 },
 *                             },
 *                             ["Location"] = new[]
 *                             {
 *                                 "New York",
 *                             },
 *                         },
 *                     }),
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"body": map[string]interface{}{
 * 				"Temperature": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"numeric": []interface{}{
 * 							">",
 * 							0,
 * 							"<=",
 * 							100,
 * 						},
 * 					},
 * 				},
 * 				"Location": []string{
 * 					"New York",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(sqsQueueTest.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			FilterCriteria: &lambda.EventSourceMappingFilterCriteriaArgs{
 * 				Filters: lambda.EventSourceMappingFilterCriteriaFilterArray{
 * 					&lambda.EventSourceMappingFilterCriteriaFilterArgs{
 * 						Pattern: pulumi.String(json0),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(sqsQueueTest.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .filterCriteria(EventSourceMappingFilterCriteriaArgs.builder()
 *                 .filters(EventSourceMappingFilterCriteriaFilterArgs.builder()
 *                     .pattern(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("body", jsonObject(
 *                                 jsonProperty("Temperature", jsonArray(jsonObject(
 *                                     jsonProperty("numeric", jsonArray(
 *                                         ">",
 *                                         0,
 *                                         "<=",
 *                                         100
 *                                     ))
 *                                 ))),
 *                                 jsonProperty("Location", jsonArray("New York"))
 *                             ))
 *                         )))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${sqsQueueTest.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       filterCriteria:
 *         filters:
 *           - pattern:
 *               fn::toJSON:
 *                 body:
 *                   Temperature:
 *                     - numeric:
 *                         - '>'
 *                         - 0
 *                         - <=
 *                         - 100
 *                   Location:
 *                     - New York
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Amazon MQ (ActiveMQ)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     batchSize: 10,
 *     eventSourceArn: exampleAwsMqBroker.arn,
 *     enabled: true,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     queues: "example",
 *     sourceAccessConfigurations: [{
 *         type: "BASIC_AUTH",
 *         uri: exampleAwsSecretsmanagerSecretVersion.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     batch_size=10,
 *     event_source_arn=example_aws_mq_broker["arn"],
 *     enabled=True,
 *     function_name=example_aws_lambda_function["arn"],
 *     queues="example",
 *     source_access_configurations=[{
 *         "type": "BASIC_AUTH",
 *         "uri": example_aws_secretsmanager_secret_version["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         BatchSize = 10,
 *         EventSourceArn = exampleAwsMqBroker.Arn,
 *         Enabled = true,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Queues = "example",
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "BASIC_AUTH",
 *                 Uri = exampleAwsSecretsmanagerSecretVersion.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			BatchSize:      pulumi.Int(10),
 * 			EventSourceArn: pulumi.Any(exampleAwsMqBroker.Arn),
 * 			Enabled:        pulumi.Bool(true),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Queues:         pulumi.String("example"),
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("BASIC_AUTH"),
 * 					Uri:  pulumi.Any(exampleAwsSecretsmanagerSecretVersion.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(10)
 *             .eventSourceArn(exampleAwsMqBroker.arn())
 *             .enabled(true)
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                 .type("BASIC_AUTH")
 *                 .uri(exampleAwsSecretsmanagerSecretVersion.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       batchSize: 10
 *       eventSourceArn: ${exampleAwsMqBroker.arn}
 *       enabled: true
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       queues: example
 *       sourceAccessConfigurations:
 *         - type: BASIC_AUTH
 *           uri: ${exampleAwsSecretsmanagerSecretVersion.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Amazon MQ (RabbitMQ)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     batchSize: 1,
 *     eventSourceArn: exampleAwsMqBroker.arn,
 *     enabled: true,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     queues: "example",
 *     sourceAccessConfigurations: [
 *         {
 *             type: "VIRTUAL_HOST",
 *             uri: "/example",
 *         },
 *         {
 *             type: "BASIC_AUTH",
 *             uri: exampleAwsSecretsmanagerSecretVersion.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     batch_size=1,
 *     event_source_arn=example_aws_mq_broker["arn"],
 *     enabled=True,
 *     function_name=example_aws_lambda_function["arn"],
 *     queues="example",
 *     source_access_configurations=[
 *         {
 *             "type": "VIRTUAL_HOST",
 *             "uri": "/example",
 *         },
 *         {
 *             "type": "BASIC_AUTH",
 *             "uri": example_aws_secretsmanager_secret_version["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         BatchSize = 1,
 *         EventSourceArn = exampleAwsMqBroker.Arn,
 *         Enabled = true,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Queues = "example",
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VIRTUAL_HOST",
 *                 Uri = "/example",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "BASIC_AUTH",
 *                 Uri = exampleAwsSecretsmanagerSecretVersion.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			BatchSize:      pulumi.Int(1),
 * 			EventSourceArn: pulumi.Any(exampleAwsMqBroker.Arn),
 * 			Enabled:        pulumi.Bool(true),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Queues:         pulumi.String("example"),
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VIRTUAL_HOST"),
 * 					Uri:  pulumi.String("/example"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("BASIC_AUTH"),
 * 					Uri:  pulumi.Any(exampleAwsSecretsmanagerSecretVersion.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(1)
 *             .eventSourceArn(exampleAwsMqBroker.arn())
 *             .enabled(true)
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VIRTUAL_HOST")
 *                     .uri("/example")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("BASIC_AUTH")
 *                     .uri(exampleAwsSecretsmanagerSecretVersion.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       batchSize: 1
 *       eventSourceArn: ${exampleAwsMqBroker.arn}
 *       enabled: true
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       queues: example
 *       sourceAccessConfigurations:
 *         - type: VIRTUAL_HOST
 *           uri: /example
 *         - type: BASIC_AUTH
 *           uri: ${exampleAwsSecretsmanagerSecretVersion.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda event source mappings using the `UUID` (event source mapping identifier). For example:
 * ```sh
 * $ pulumi import aws:lambda/eventSourceMapping:EventSourceMapping event_source_mapping 12345kxodurf3443
 * ```
 */
public class EventSourceMapping internal constructor(
    override val javaResource: com.pulumi.aws.lambda.EventSourceMapping,
) : KotlinCustomResource(javaResource, EventSourceMappingMapper) {
    /**
     * Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
     */
    public val amazonManagedKafkaEventSourceConfig:
        Output<EventSourceMappingAmazonManagedKafkaEventSourceConfig>
        get() = javaResource.amazonManagedKafkaEventSourceConfig().applyValue({ args0 ->
            args0.let({ args0 -> eventSourceMappingAmazonManagedKafkaEventSourceConfigToKotlin(args0) })
        })

    /**
     * The largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
     */
    public val batchSize: Output<Int>?
        get() = javaResource.batchSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * - (Optional) If the function returns an error, split the batch in two and retry. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
     */
    public val bisectBatchOnFunctionError: Output<Boolean>?
        get() = javaResource.bisectBatchOnFunctionError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * - (Optional) An Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). Detailed below.
     */
    public val destinationConfig: Output<EventSourceMappingDestinationConfig>?
        get() = javaResource.destinationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingDestinationConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
     */
    public val documentDbEventSourceConfig: Output<EventSourceMappingDocumentDbEventSourceConfig>?
        get() = javaResource.documentDbEventSourceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSourceMappingDocumentDbEventSourceConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Determines if the mapping will be enabled on creation. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The event source ARN - this is required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream.  It is incompatible with a Self Managed Kafka source.
     */
    public val eventSourceArn: Output<String>?
        get() = javaResource.eventSourceArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
     */
    public val filterCriteria: Output<EventSourceMappingFilterCriteria>?
        get() = javaResource.filterCriteria().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingFilterCriteriaToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The the ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
     */
    public val functionArn: Output<String>
        get() = javaResource.functionArn().applyValue({ args0 -> args0 })

    /**
     * The name or the ARN of the Lambda function that will be subscribing to events.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    public val functionResponseTypes: Output<List<String>>?
        get() = javaResource.functionResponseTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The date this resource was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The result of the last AWS Lambda invocation of your Lambda function.
     */
    public val lastProcessingResult: Output<String>
        get() = javaResource.lastProcessingResult().applyValue({ args0 -> args0 })

    /**
     * The maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer (or accumulate in the case of an SQS queue event source) until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. If the batch it reads from the stream/queue only has one record in it, Lambda only sends one record to the function. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
     */
    public val maximumBatchingWindowInSeconds: Output<Int>?
        get() = javaResource.maximumBatchingWindowInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * - (Optional) The maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
     */
    public val maximumRecordAgeInSeconds: Output<Int>
        get() = javaResource.maximumRecordAgeInSeconds().applyValue({ args0 -> args0 })

    /**
     * - (Optional) The maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
     */
    public val maximumRetryAttempts: Output<Int>
        get() = javaResource.maximumRetryAttempts().applyValue({ args0 -> args0 })

    /**
     * - (Optional) The number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
     */
    public val parallelizationFactor: Output<Int>
        get() = javaResource.parallelizationFactor().applyValue({ args0 -> args0 })

    /**
     * The name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
     */
    public val queues: Output<String>?
        get() = javaResource.queues().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Scaling configuration of the event source. Only available for SQS queues. Detailed below.
     */
    public val scalingConfig: Output<EventSourceMappingScalingConfig>?
        get() = javaResource.scalingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingScalingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
     */
    public val selfManagedEventSource: Output<EventSourceMappingSelfManagedEventSource>?
        get() = javaResource.selfManagedEventSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSourceMappingSelfManagedEventSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
     */
    public val selfManagedKafkaEventSourceConfig:
        Output<EventSourceMappingSelfManagedKafkaEventSourceConfig>
        get() = javaResource.selfManagedKafkaEventSourceConfig().applyValue({ args0 ->
            args0.let({ args0 -> eventSourceMappingSelfManagedKafkaEventSourceConfigToKotlin(args0) })
        })

    /**
     * For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    public val sourceAccessConfigurations: Output<List<EventSourceMappingSourceAccessConfiguration>>?
        get() = javaResource.sourceAccessConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventSourceMappingSourceAccessConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs&#46;aws&#46;amazon&#46;com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator&#46;html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
     */
    public val startingPosition: Output<String>?
        get() = javaResource.startingPosition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
     */
    public val startingPositionTimestamp: Output<String>?
        get() = javaResource.startingPositionTimestamp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the event source mapping.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The reason the event source mapping is in its current state.
     */
    public val stateTransitionReason: Output<String>
        get() = javaResource.stateTransitionReason().applyValue({ args0 -> args0 })

    /**
     * The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    public val topics: Output<List<String>>?
        get() = javaResource.topics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
     */
    public val tumblingWindowInSeconds: Output<Int>?
        get() = javaResource.tumblingWindowInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The UUID of the created event source mapping.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object EventSourceMappingMapper : ResourceMapper<EventSourceMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.EventSourceMapping::class == javaResource::class

    override fun map(javaResource: Resource): EventSourceMapping = EventSourceMapping(
        javaResource as
            com.pulumi.aws.lambda.EventSourceMapping,
    )
}

/**
 * @see [EventSourceMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSourceMapping].
 */
public suspend fun eventSourceMapping(
    name: String,
    block: suspend EventSourceMappingResourceBuilder.() -> Unit,
): EventSourceMapping {
    val builder = EventSourceMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSourceMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSourceMapping(name: String): EventSourceMapping {
    val builder = EventSourceMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
