@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.EventSourceMappingArgs.builder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingDestinationConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingDestinationConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingDocumentDbEventSourceConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingDocumentDbEventSourceConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingFilterCriteriaArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingFilterCriteriaArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingScalingConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingScalingConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSelfManagedEventSourceArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSelfManagedEventSourceArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSourceAccessConfigurationArgs
import com.pulumi.aws.lambda.kotlin.inputs.EventSourceMappingSourceAccessConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Lambda event source mapping. This allows Lambda functions to get events from Kinesis, DynamoDB, SQS, Amazon MQ and Managed Streaming for Apache Kafka (MSK).
 * For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
 * For information about event source mappings, see [CreateEventSourceMapping](http://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html) in the API docs.
 * ## Example Usage
 * ### DynamoDB
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsDynamodbTable.streamArn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     startingPosition: "LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_dynamodb_table["streamArn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     starting_position="LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsDynamodbTable.StreamArn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         StartingPosition = "LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn:   pulumi.Any(exampleAwsDynamodbTable.StreamArn),
 * 			FunctionName:     pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			StartingPosition: pulumi.String("LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsDynamodbTable.streamArn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsDynamodbTable.streamArn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       startingPosition: LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Kinesis
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsKinesisStream.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     startingPosition: "LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_kinesis_stream["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     starting_position="LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsKinesisStream.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         StartingPosition = "LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn:   pulumi.Any(exampleAwsKinesisStream.Arn),
 * 			FunctionName:     pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			StartingPosition: pulumi.String("LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsKinesisStream.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsKinesisStream.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       startingPosition: LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Managed Streaming for Apache Kafka (MSK)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: exampleAwsMskCluster.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     topics: ["Example"],
 *     startingPosition: "TRIM_HORIZON",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=example_aws_msk_cluster["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     topics=["Example"],
 *     starting_position="TRIM_HORIZON")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = exampleAwsMskCluster.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Topics = new[]
 *         {
 *             "Example",
 *         },
 *         StartingPosition = "TRIM_HORIZON",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(exampleAwsMskCluster.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Topics: pulumi.StringArray{
 * 				pulumi.String("Example"),
 * 			},
 * 			StartingPosition: pulumi.String("TRIM_HORIZON"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(exampleAwsMskCluster.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${exampleAwsMskCluster.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       topics:
 *         - Example
 *       startingPosition: TRIM_HORIZON
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Self Managed Apache Kafka
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     functionName: exampleAwsLambdaFunction.arn,
 *     topics: ["Example"],
 *     startingPosition: "TRIM_HORIZON",
 *     selfManagedEventSource: {
 *         endpoints: {
 *             KAFKA_BOOTSTRAP_SERVERS: "kafka1.example.com:9092,kafka2.example.com:9092",
 *         },
 *     },
 *     sourceAccessConfigurations: [
 *         {
 *             type: "VPC_SUBNET",
 *             uri: "subnet:subnet-example1",
 *         },
 *         {
 *             type: "VPC_SUBNET",
 *             uri: "subnet:subnet-example2",
 *         },
 *         {
 *             type: "VPC_SECURITY_GROUP",
 *             uri: "security_group:sg-example",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     function_name=example_aws_lambda_function["arn"],
 *     topics=["Example"],
 *     starting_position="TRIM_HORIZON",
 *     self_managed_event_source={
 *         "endpoints": {
 *             "kafk_a__bootstra_p__servers": "kafka1.example.com:9092,kafka2.example.com:9092",
 *         },
 *     },
 *     source_access_configurations=[
 *         {
 *             "type": "VPC_SUBNET",
 *             "uri": "subnet:subnet-example1",
 *         },
 *         {
 *             "type": "VPC_SUBNET",
 *             "uri": "subnet:subnet-example2",
 *         },
 *         {
 *             "type": "VPC_SECURITY_GROUP",
 *             "uri": "security_group:sg-example",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Topics = new[]
 *         {
 *             "Example",
 *         },
 *         StartingPosition = "TRIM_HORIZON",
 *         SelfManagedEventSource = new Aws.Lambda.Inputs.EventSourceMappingSelfManagedEventSourceArgs
 *         {
 *             Endpoints =
 *             {
 *                 { "KAFKA_BOOTSTRAP_SERVERS", "kafka1.example.com:9092,kafka2.example.com:9092" },
 *             },
 *         },
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SUBNET",
 *                 Uri = "subnet:subnet-example1",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SUBNET",
 *                 Uri = "subnet:subnet-example2",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VPC_SECURITY_GROUP",
 *                 Uri = "security_group:sg-example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Topics: pulumi.StringArray{
 * 				pulumi.String("Example"),
 * 			},
 * 			StartingPosition: pulumi.String("TRIM_HORIZON"),
 * 			SelfManagedEventSource: &lambda.EventSourceMappingSelfManagedEventSourceArgs{
 * 				Endpoints: pulumi.StringMap{
 * 					"KAFKA_BOOTSTRAP_SERVERS": pulumi.String("kafka1.example.com:9092,kafka2.example.com:9092"),
 * 				},
 * 			},
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SUBNET"),
 * 					Uri:  pulumi.String("subnet:subnet-example1"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SUBNET"),
 * 					Uri:  pulumi.String("subnet:subnet-example2"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VPC_SECURITY_GROUP"),
 * 					Uri:  pulumi.String("security_group:sg-example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .selfManagedEventSource(EventSourceMappingSelfManagedEventSourceArgs.builder()
 *                 .endpoints(Map.of("KAFKA_BOOTSTRAP_SERVERS", "kafka1.example.com:9092,kafka2.example.com:9092"))
 *                 .build())
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example1")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example2")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SECURITY_GROUP")
 *                     .uri("security_group:sg-example")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       topics:
 *         - Example
 *       startingPosition: TRIM_HORIZON
 *       selfManagedEventSource:
 *         endpoints:
 *           KAFKA_BOOTSTRAP_SERVERS: kafka1.example.com:9092,kafka2.example.com:9092
 *       sourceAccessConfigurations:
 *         - type: VPC_SUBNET
 *           uri: subnet:subnet-example1
 *         - type: VPC_SUBNET
 *           uri: subnet:subnet-example2
 *         - type: VPC_SECURITY_GROUP
 *           uri: security_group:sg-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### SQS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: sqsQueueTest.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=sqs_queue_test["arn"],
 *     function_name=example_aws_lambda_function["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = sqsQueueTest.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(sqsQueueTest.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(sqsQueueTest.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${sqsQueueTest.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### SQS with event filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     eventSourceArn: sqsQueueTest.arn,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     filterCriteria: {
 *         filters: [{
 *             pattern: JSON.stringify({
 *                 body: {
 *                     Temperature: [{
 *                         numeric: [
 *                             ">",
 *                             0,
 *                             "<=",
 *                             100,
 *                         ],
 *                     }],
 *                     Location: ["New York"],
 *                 },
 *             }),
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     event_source_arn=sqs_queue_test["arn"],
 *     function_name=example_aws_lambda_function["arn"],
 *     filter_criteria={
 *         "filters": [{
 *             "pattern": json.dumps({
 *                 "body": {
 *                     "temperature": [{
 *                         "numeric": [
 *                             ">",
 *                             0,
 *                             "<=",
 *                             100,
 *                         ],
 *                     }],
 *                     "location": ["New York"],
 *                 },
 *             }),
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         EventSourceArn = sqsQueueTest.Arn,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         FilterCriteria = new Aws.Lambda.Inputs.EventSourceMappingFilterCriteriaArgs
 *         {
 *             Filters = new[]
 *             {
 *                 new Aws.Lambda.Inputs.EventSourceMappingFilterCriteriaFilterArgs
 *                 {
 *                     Pattern = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                     {
 *                         ["body"] = new Dictionary<string, object?>
 *                         {
 *                             ["Temperature"] = new[]
 *                             {
 *                                 new Dictionary<string, object?>
 *                                 {
 *                                     ["numeric"] = new object?[]
 *                                     {
 *                                         ">",
 *                                         0,
 *                                         "<=",
 *                                         100,
 *                                     },
 *                                 },
 *                             },
 *                             ["Location"] = new[]
 *                             {
 *                                 "New York",
 *                             },
 *                         },
 *                     }),
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"body": map[string]interface{}{
 * 				"Temperature": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"numeric": []interface{}{
 * 							">",
 * 							0,
 * 							"<=",
 * 							100,
 * 						},
 * 					},
 * 				},
 * 				"Location": []string{
 * 					"New York",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			EventSourceArn: pulumi.Any(sqsQueueTest.Arn),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			FilterCriteria: &lambda.EventSourceMappingFilterCriteriaArgs{
 * 				Filters: lambda.EventSourceMappingFilterCriteriaFilterArray{
 * 					&lambda.EventSourceMappingFilterCriteriaFilterArgs{
 * 						Pattern: pulumi.String(json0),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(sqsQueueTest.arn())
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .filterCriteria(EventSourceMappingFilterCriteriaArgs.builder()
 *                 .filters(EventSourceMappingFilterCriteriaFilterArgs.builder()
 *                     .pattern(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("body", jsonObject(
 *                                 jsonProperty("Temperature", jsonArray(jsonObject(
 *                                     jsonProperty("numeric", jsonArray(
 *                                         ">",
 *                                         0,
 *                                         "<=",
 *                                         100
 *                                     ))
 *                                 ))),
 *                                 jsonProperty("Location", jsonArray("New York"))
 *                             ))
 *                         )))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       eventSourceArn: ${sqsQueueTest.arn}
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       filterCriteria:
 *         filters:
 *           - pattern:
 *               fn::toJSON:
 *                 body:
 *                   Temperature:
 *                     - numeric:
 *                         - '>'
 *                         - 0
 *                         - <=
 *                         - 100
 *                   Location:
 *                     - New York
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Amazon MQ (ActiveMQ)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     batchSize: 10,
 *     eventSourceArn: exampleAwsMqBroker.arn,
 *     enabled: true,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     queues: "example",
 *     sourceAccessConfigurations: [{
 *         type: "BASIC_AUTH",
 *         uri: exampleAwsSecretsmanagerSecretVersion.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     batch_size=10,
 *     event_source_arn=example_aws_mq_broker["arn"],
 *     enabled=True,
 *     function_name=example_aws_lambda_function["arn"],
 *     queues="example",
 *     source_access_configurations=[{
 *         "type": "BASIC_AUTH",
 *         "uri": example_aws_secretsmanager_secret_version["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         BatchSize = 10,
 *         EventSourceArn = exampleAwsMqBroker.Arn,
 *         Enabled = true,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Queues = "example",
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "BASIC_AUTH",
 *                 Uri = exampleAwsSecretsmanagerSecretVersion.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			BatchSize:      pulumi.Int(10),
 * 			EventSourceArn: pulumi.Any(exampleAwsMqBroker.Arn),
 * 			Enabled:        pulumi.Bool(true),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Queues:         pulumi.String("example"),
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("BASIC_AUTH"),
 * 					Uri:  pulumi.Any(exampleAwsSecretsmanagerSecretVersion.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(10)
 *             .eventSourceArn(exampleAwsMqBroker.arn())
 *             .enabled(true)
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                 .type("BASIC_AUTH")
 *                 .uri(exampleAwsSecretsmanagerSecretVersion.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       batchSize: 10
 *       eventSourceArn: ${exampleAwsMqBroker.arn}
 *       enabled: true
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       queues: example
 *       sourceAccessConfigurations:
 *         - type: BASIC_AUTH
 *           uri: ${exampleAwsSecretsmanagerSecretVersion.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Amazon MQ (RabbitMQ)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.EventSourceMapping("example", {
 *     batchSize: 1,
 *     eventSourceArn: exampleAwsMqBroker.arn,
 *     enabled: true,
 *     functionName: exampleAwsLambdaFunction.arn,
 *     queues: "example",
 *     sourceAccessConfigurations: [
 *         {
 *             type: "VIRTUAL_HOST",
 *             uri: "/example",
 *         },
 *         {
 *             type: "BASIC_AUTH",
 *             uri: exampleAwsSecretsmanagerSecretVersion.arn,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.EventSourceMapping("example",
 *     batch_size=1,
 *     event_source_arn=example_aws_mq_broker["arn"],
 *     enabled=True,
 *     function_name=example_aws_lambda_function["arn"],
 *     queues="example",
 *     source_access_configurations=[
 *         {
 *             "type": "VIRTUAL_HOST",
 *             "uri": "/example",
 *         },
 *         {
 *             "type": "BASIC_AUTH",
 *             "uri": example_aws_secretsmanager_secret_version["arn"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.EventSourceMapping("example", new()
 *     {
 *         BatchSize = 1,
 *         EventSourceArn = exampleAwsMqBroker.Arn,
 *         Enabled = true,
 *         FunctionName = exampleAwsLambdaFunction.Arn,
 *         Queues = "example",
 *         SourceAccessConfigurations = new[]
 *         {
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "VIRTUAL_HOST",
 *                 Uri = "/example",
 *             },
 *             new Aws.Lambda.Inputs.EventSourceMappingSourceAccessConfigurationArgs
 *             {
 *                 Type = "BASIC_AUTH",
 *                 Uri = exampleAwsSecretsmanagerSecretVersion.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewEventSourceMapping(ctx, "example", &lambda.EventSourceMappingArgs{
 * 			BatchSize:      pulumi.Int(1),
 * 			EventSourceArn: pulumi.Any(exampleAwsMqBroker.Arn),
 * 			Enabled:        pulumi.Bool(true),
 * 			FunctionName:   pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Queues:         pulumi.String("example"),
 * 			SourceAccessConfigurations: lambda.EventSourceMappingSourceAccessConfigurationArray{
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("VIRTUAL_HOST"),
 * 					Uri:  pulumi.String("/example"),
 * 				},
 * 				&lambda.EventSourceMappingSourceAccessConfigurationArgs{
 * 					Type: pulumi.String("BASIC_AUTH"),
 * 					Uri:  pulumi.Any(exampleAwsSecretsmanagerSecretVersion.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(1)
 *             .eventSourceArn(exampleAwsMqBroker.arn())
 *             .enabled(true)
 *             .functionName(exampleAwsLambdaFunction.arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VIRTUAL_HOST")
 *                     .uri("/example")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("BASIC_AUTH")
 *                     .uri(exampleAwsSecretsmanagerSecretVersion.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:EventSourceMapping
 *     properties:
 *       batchSize: 1
 *       eventSourceArn: ${exampleAwsMqBroker.arn}
 *       enabled: true
 *       functionName: ${exampleAwsLambdaFunction.arn}
 *       queues: example
 *       sourceAccessConfigurations:
 *         - type: VIRTUAL_HOST
 *           uri: /example
 *         - type: BASIC_AUTH
 *           uri: ${exampleAwsSecretsmanagerSecretVersion.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda event source mappings using the `UUID` (event source mapping identifier). For example:
 * ```sh
 * $ pulumi import aws:lambda/eventSourceMapping:EventSourceMapping event_source_mapping 12345kxodurf3443
 * ```
 * @property amazonManagedKafkaEventSourceConfig Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
 * @property batchSize The largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
 * @property bisectBatchOnFunctionError - (Optional) If the function returns an error, split the batch in two and retry. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
 * @property destinationConfig - (Optional) An Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). Detailed below.
 * @property documentDbEventSourceConfig - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
 * @property enabled Determines if the mapping will be enabled on creation. Defaults to `true`.
 * @property eventSourceArn The event source ARN - this is required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream.  It is incompatible with a Self Managed Kafka source.
 * @property filterCriteria The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
 * @property functionName The name or the ARN of the Lambda function that will be subscribing to events.
 * @property functionResponseTypes A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
 * @property maximumBatchingWindowInSeconds The maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer (or accumulate in the case of an SQS queue event source) until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. If the batch it reads from the stream/queue only has one record in it, Lambda only sends one record to the function. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
 * @property maximumRecordAgeInSeconds - (Optional) The maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
 * @property maximumRetryAttempts - (Optional) The maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
 * @property parallelizationFactor - (Optional) The number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
 * @property queues The name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
 * @property scalingConfig Scaling configuration of the event source. Only available for SQS queues. Detailed below.
 * @property selfManagedEventSource - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
 * @property selfManagedKafkaEventSourceConfig Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
 * @property sourceAccessConfigurations For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
 * @property startingPosition The position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs&#46;aws&#46;amazon&#46;com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator&#46;html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
 * @property startingPositionTimestamp A timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
 * @property topics The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
 * @property tumblingWindowInSeconds The duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
 */
public data class EventSourceMappingArgs(
    public val amazonManagedKafkaEventSourceConfig: Output<EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs>? = null,
    public val batchSize: Output<Int>? = null,
    public val bisectBatchOnFunctionError: Output<Boolean>? = null,
    public val destinationConfig: Output<EventSourceMappingDestinationConfigArgs>? = null,
    public val documentDbEventSourceConfig: Output<EventSourceMappingDocumentDbEventSourceConfigArgs>? =
        null,
    public val enabled: Output<Boolean>? = null,
    public val eventSourceArn: Output<String>? = null,
    public val filterCriteria: Output<EventSourceMappingFilterCriteriaArgs>? = null,
    public val functionName: Output<String>? = null,
    public val functionResponseTypes: Output<List<String>>? = null,
    public val maximumBatchingWindowInSeconds: Output<Int>? = null,
    public val maximumRecordAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
    public val parallelizationFactor: Output<Int>? = null,
    public val queues: Output<String>? = null,
    public val scalingConfig: Output<EventSourceMappingScalingConfigArgs>? = null,
    public val selfManagedEventSource: Output<EventSourceMappingSelfManagedEventSourceArgs>? = null,
    public val selfManagedKafkaEventSourceConfig: Output<EventSourceMappingSelfManagedKafkaEventSourceConfigArgs>? = null,
    public val sourceAccessConfigurations: Output<List<EventSourceMappingSourceAccessConfigurationArgs>>? = null,
    public val startingPosition: Output<String>? = null,
    public val startingPositionTimestamp: Output<String>? = null,
    public val topics: Output<List<String>>? = null,
    public val tumblingWindowInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.EventSourceMappingArgs> {
    override fun toJava(): com.pulumi.aws.lambda.EventSourceMappingArgs =
        com.pulumi.aws.lambda.EventSourceMappingArgs.builder()
            .amazonManagedKafkaEventSourceConfig(
                amazonManagedKafkaEventSourceConfig?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .bisectBatchOnFunctionError(bisectBatchOnFunctionError?.applyValue({ args0 -> args0 }))
            .destinationConfig(destinationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .documentDbEventSourceConfig(
                documentDbEventSourceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventSourceArn(eventSourceArn?.applyValue({ args0 -> args0 }))
            .filterCriteria(filterCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .functionResponseTypes(functionResponseTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRecordAgeInSeconds(maximumRecordAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 }))
            .parallelizationFactor(parallelizationFactor?.applyValue({ args0 -> args0 }))
            .queues(queues?.applyValue({ args0 -> args0 }))
            .scalingConfig(scalingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selfManagedEventSource(
                selfManagedEventSource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .selfManagedKafkaEventSourceConfig(
                selfManagedKafkaEventSourceConfig?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sourceAccessConfigurations(
                sourceAccessConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .startingPosition(startingPosition?.applyValue({ args0 -> args0 }))
            .startingPositionTimestamp(startingPositionTimestamp?.applyValue({ args0 -> args0 }))
            .topics(topics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tumblingWindowInSeconds(tumblingWindowInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingArgs].
 */
@PulumiTagMarker
public class EventSourceMappingArgsBuilder internal constructor() {
    private var amazonManagedKafkaEventSourceConfig:
        Output<EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs>? = null

    private var batchSize: Output<Int>? = null

    private var bisectBatchOnFunctionError: Output<Boolean>? = null

    private var destinationConfig: Output<EventSourceMappingDestinationConfigArgs>? = null

    private var documentDbEventSourceConfig:
        Output<EventSourceMappingDocumentDbEventSourceConfigArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var eventSourceArn: Output<String>? = null

    private var filterCriteria: Output<EventSourceMappingFilterCriteriaArgs>? = null

    private var functionName: Output<String>? = null

    private var functionResponseTypes: Output<List<String>>? = null

    private var maximumBatchingWindowInSeconds: Output<Int>? = null

    private var maximumRecordAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    private var parallelizationFactor: Output<Int>? = null

    private var queues: Output<String>? = null

    private var scalingConfig: Output<EventSourceMappingScalingConfigArgs>? = null

    private var selfManagedEventSource: Output<EventSourceMappingSelfManagedEventSourceArgs>? = null

    private var selfManagedKafkaEventSourceConfig:
        Output<EventSourceMappingSelfManagedKafkaEventSourceConfigArgs>? = null

    private var sourceAccessConfigurations:
        Output<List<EventSourceMappingSourceAccessConfigurationArgs>>? = null

    private var startingPosition: Output<String>? = null

    private var startingPositionTimestamp: Output<String>? = null

    private var topics: Output<List<String>>? = null

    private var tumblingWindowInSeconds: Output<Int>? = null

    /**
     * @param value Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("bxyvpfnrgnaqydqs")
    public suspend fun amazonManagedKafkaEventSourceConfig(`value`: Output<EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs>) {
        this.amazonManagedKafkaEventSourceConfig = value
    }

    /**
     * @param value The largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
     */
    @JvmName("yfsdsypnotroplrt")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value - (Optional) If the function returns an error, split the batch in two and retry. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
     */
    @JvmName("huekvmoptgcvbxqd")
    public suspend fun bisectBatchOnFunctionError(`value`: Output<Boolean>) {
        this.bisectBatchOnFunctionError = value
    }

    /**
     * @param value - (Optional) An Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). Detailed below.
     */
    @JvmName("vhtprcqdjgaltlfu")
    public suspend fun destinationConfig(`value`: Output<EventSourceMappingDestinationConfigArgs>) {
        this.destinationConfig = value
    }

    /**
     * @param value - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
     */
    @JvmName("lfaylirfpvjvtapj")
    public suspend fun documentDbEventSourceConfig(`value`: Output<EventSourceMappingDocumentDbEventSourceConfigArgs>) {
        this.documentDbEventSourceConfig = value
    }

    /**
     * @param value Determines if the mapping will be enabled on creation. Defaults to `true`.
     */
    @JvmName("lfnvhmqmbvivmuow")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The event source ARN - this is required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream.  It is incompatible with a Self Managed Kafka source.
     */
    @JvmName("ybsoxuaigvfdhbes")
    public suspend fun eventSourceArn(`value`: Output<String>) {
        this.eventSourceArn = value
    }

    /**
     * @param value The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
     */
    @JvmName("nxhtfrehydhxtllr")
    public suspend fun filterCriteria(`value`: Output<EventSourceMappingFilterCriteriaArgs>) {
        this.filterCriteria = value
    }

    /**
     * @param value The name or the ARN of the Lambda function that will be subscribing to events.
     */
    @JvmName("uxejdauhlwjnjtrm")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    @JvmName("ujlrsnxjkipakcdx")
    public suspend fun functionResponseTypes(`value`: Output<List<String>>) {
        this.functionResponseTypes = value
    }

    @JvmName("jrhgxrshutkuyxuv")
    public suspend fun functionResponseTypes(vararg values: Output<String>) {
        this.functionResponseTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    @JvmName("uldjrxgphttyuqyi")
    public suspend fun functionResponseTypes(values: List<Output<String>>) {
        this.functionResponseTypes = Output.all(values)
    }

    /**
     * @param value The maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer (or accumulate in the case of an SQS queue event source) until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. If the batch it reads from the stream/queue only has one record in it, Lambda only sends one record to the function. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
     */
    @JvmName("wnbsjfdycjluhndk")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Output<Int>) {
        this.maximumBatchingWindowInSeconds = value
    }

    /**
     * @param value - (Optional) The maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
     */
    @JvmName("wawfwaaysreslwlh")
    public suspend fun maximumRecordAgeInSeconds(`value`: Output<Int>) {
        this.maximumRecordAgeInSeconds = value
    }

    /**
     * @param value - (Optional) The maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
     */
    @JvmName("ojnfqqeuhwkfwkpc")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value - (Optional) The number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
     */
    @JvmName("qtudiiltnqunoocf")
    public suspend fun parallelizationFactor(`value`: Output<Int>) {
        this.parallelizationFactor = value
    }

    /**
     * @param value The name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
     */
    @JvmName("hwksuymtdhgndwgs")
    public suspend fun queues(`value`: Output<String>) {
        this.queues = value
    }

    /**
     * @param value Scaling configuration of the event source. Only available for SQS queues. Detailed below.
     */
    @JvmName("qvpnlucpgfdwasxp")
    public suspend fun scalingConfig(`value`: Output<EventSourceMappingScalingConfigArgs>) {
        this.scalingConfig = value
    }

    /**
     * @param value - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
     */
    @JvmName("pxxebvlmkuffrcuq")
    public suspend fun selfManagedEventSource(`value`: Output<EventSourceMappingSelfManagedEventSourceArgs>) {
        this.selfManagedEventSource = value
    }

    /**
     * @param value Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("ptnhvoxqqsxwdpeg")
    public suspend fun selfManagedKafkaEventSourceConfig(`value`: Output<EventSourceMappingSelfManagedKafkaEventSourceConfigArgs>) {
        this.selfManagedKafkaEventSourceConfig = value
    }

    /**
     * @param value For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("leonyiifihfapnrf")
    public suspend fun sourceAccessConfigurations(`value`: Output<List<EventSourceMappingSourceAccessConfigurationArgs>>) {
        this.sourceAccessConfigurations = value
    }

    @JvmName("qdujjbuurptamqmg")
    public suspend fun sourceAccessConfigurations(vararg values: Output<EventSourceMappingSourceAccessConfigurationArgs>) {
        this.sourceAccessConfigurations = Output.all(values.asList())
    }

    /**
     * @param values For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("wdrothfperqntokd")
    public suspend fun sourceAccessConfigurations(values: List<Output<EventSourceMappingSourceAccessConfigurationArgs>>) {
        this.sourceAccessConfigurations = Output.all(values)
    }

    /**
     * @param value The position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs&#46;aws&#46;amazon&#46;com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator&#46;html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
     */
    @JvmName("dpwohvjfrjluqwyi")
    public suspend fun startingPosition(`value`: Output<String>) {
        this.startingPosition = value
    }

    /**
     * @param value A timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
     */
    @JvmName("crhxnrpaawqqolvr")
    public suspend fun startingPositionTimestamp(`value`: Output<String>) {
        this.startingPositionTimestamp = value
    }

    /**
     * @param value The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    @JvmName("fwkfskcalfqpocnu")
    public suspend fun topics(`value`: Output<List<String>>) {
        this.topics = value
    }

    @JvmName("odayxyrnvstgwehv")
    public suspend fun topics(vararg values: Output<String>) {
        this.topics = Output.all(values.asList())
    }

    /**
     * @param values The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    @JvmName("ysgsmvwymfnpkamx")
    public suspend fun topics(values: List<Output<String>>) {
        this.topics = Output.all(values)
    }

    /**
     * @param value The duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
     */
    @JvmName("hyjsntghbfjwnyaj")
    public suspend fun tumblingWindowInSeconds(`value`: Output<Int>) {
        this.tumblingWindowInSeconds = value
    }

    /**
     * @param value Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("tdpcukugxwkwxelh")
    public suspend fun amazonManagedKafkaEventSourceConfig(`value`: EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonManagedKafkaEventSourceConfig = mapped
    }

    /**
     * @param argument Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("nxfkjbtjgriduetf")
    public suspend fun amazonManagedKafkaEventSourceConfig(argument: suspend EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amazonManagedKafkaEventSourceConfig = mapped
    }

    /**
     * @param value The largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
     */
    @JvmName("afswdhejcyrymuwq")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value - (Optional) If the function returns an error, split the batch in two and retry. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
     */
    @JvmName("dvuafnspklumujmj")
    public suspend fun bisectBatchOnFunctionError(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bisectBatchOnFunctionError = mapped
    }

    /**
     * @param value - (Optional) An Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). Detailed below.
     */
    @JvmName("rwefalgakjcvghaj")
    public suspend fun destinationConfig(`value`: EventSourceMappingDestinationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfig = mapped
    }

    /**
     * @param argument - (Optional) An Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). Detailed below.
     */
    @JvmName("obluawkoqagmyjbc")
    public suspend fun destinationConfig(argument: suspend EventSourceMappingDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingDestinationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfig = mapped
    }

    /**
     * @param value - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
     */
    @JvmName("rqrugtdvquhnpprh")
    public suspend fun documentDbEventSourceConfig(`value`: EventSourceMappingDocumentDbEventSourceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentDbEventSourceConfig = mapped
    }

    /**
     * @param argument - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
     */
    @JvmName("lecbfgwhrdhygqyf")
    public suspend fun documentDbEventSourceConfig(argument: suspend EventSourceMappingDocumentDbEventSourceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingDocumentDbEventSourceConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.documentDbEventSourceConfig = mapped
    }

    /**
     * @param value Determines if the mapping will be enabled on creation. Defaults to `true`.
     */
    @JvmName("psrgnlogmjdaboxx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The event source ARN - this is required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream.  It is incompatible with a Self Managed Kafka source.
     */
    @JvmName("etabrxnaqtuchnud")
    public suspend fun eventSourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceArn = mapped
    }

    /**
     * @param value The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
     */
    @JvmName("kxalmhwheueteerq")
    public suspend fun filterCriteria(`value`: EventSourceMappingFilterCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterCriteria = mapped
    }

    /**
     * @param argument The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
     */
    @JvmName("cariqoxbrwomxjpr")
    public suspend fun filterCriteria(argument: suspend EventSourceMappingFilterCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingFilterCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filterCriteria = mapped
    }

    /**
     * @param value The name or the ARN of the Lambda function that will be subscribing to events.
     */
    @JvmName("mfgxnwlwewegyymx")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    @JvmName("ptjjrkwtrikillht")
    public suspend fun functionResponseTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionResponseTypes = mapped
    }

    /**
     * @param values A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    @JvmName("fbwfjkcewyemsfjq")
    public suspend fun functionResponseTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionResponseTypes = mapped
    }

    /**
     * @param value The maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer (or accumulate in the case of an SQS queue event source) until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. If the batch it reads from the stream/queue only has one record in it, Lambda only sends one record to the function. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
     */
    @JvmName("lwtrywncllxhywqx")
    public suspend fun maximumBatchingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBatchingWindowInSeconds = mapped
    }

    /**
     * @param value - (Optional) The maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
     */
    @JvmName("ewwqhbexscjrugcs")
    public suspend fun maximumRecordAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRecordAgeInSeconds = mapped
    }

    /**
     * @param value - (Optional) The maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
     */
    @JvmName("muqolepxmqnxbuch")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    /**
     * @param value - (Optional) The number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
     */
    @JvmName("onhdbmkggbxbdncs")
    public suspend fun parallelizationFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelizationFactor = mapped
    }

    /**
     * @param value The name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
     */
    @JvmName("mflcmngextqrpbxi")
    public suspend fun queues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queues = mapped
    }

    /**
     * @param value Scaling configuration of the event source. Only available for SQS queues. Detailed below.
     */
    @JvmName("bcarwdosseasldtu")
    public suspend fun scalingConfig(`value`: EventSourceMappingScalingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingConfig = mapped
    }

    /**
     * @param argument Scaling configuration of the event source. Only available for SQS queues. Detailed below.
     */
    @JvmName("hqromyxmmrhmcviv")
    public suspend fun scalingConfig(argument: suspend EventSourceMappingScalingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingScalingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scalingConfig = mapped
    }

    /**
     * @param value - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
     */
    @JvmName("eqfgwcmowuhpvmwv")
    public suspend fun selfManagedEventSource(`value`: EventSourceMappingSelfManagedEventSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfManagedEventSource = mapped
    }

    /**
     * @param argument - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
     */
    @JvmName("gproefnuxesdqpup")
    public suspend fun selfManagedEventSource(argument: suspend EventSourceMappingSelfManagedEventSourceArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingSelfManagedEventSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.selfManagedEventSource = mapped
    }

    /**
     * @param value Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("cnicdbgphlrrubmi")
    public suspend fun selfManagedKafkaEventSourceConfig(`value`: EventSourceMappingSelfManagedKafkaEventSourceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfManagedKafkaEventSourceConfig = mapped
    }

    /**
     * @param argument Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
     */
    @JvmName("qsaxwtukdpjkkbuv")
    public suspend fun selfManagedKafkaEventSourceConfig(argument: suspend EventSourceMappingSelfManagedKafkaEventSourceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingSelfManagedKafkaEventSourceConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.selfManagedKafkaEventSourceConfig = mapped
    }

    /**
     * @param value For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("vlkingcgathnhbjl")
    public suspend fun sourceAccessConfigurations(`value`: List<EventSourceMappingSourceAccessConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAccessConfigurations = mapped
    }

    /**
     * @param argument For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("hcjdukwgfkldgaln")
    public suspend fun sourceAccessConfigurations(argument: List<suspend EventSourceMappingSourceAccessConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventSourceMappingSourceAccessConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceAccessConfigurations = mapped
    }

    /**
     * @param argument For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("vfhyasamvcmvsnsx")
    public suspend fun sourceAccessConfigurations(vararg argument: suspend EventSourceMappingSourceAccessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventSourceMappingSourceAccessConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceAccessConfigurations = mapped
    }

    /**
     * @param argument For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("qxcgxcpliximniip")
    public suspend fun sourceAccessConfigurations(argument: suspend EventSourceMappingSourceAccessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventSourceMappingSourceAccessConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceAccessConfigurations = mapped
    }

    /**
     * @param values For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    @JvmName("bcucblmpvykthevs")
    public suspend fun sourceAccessConfigurations(vararg values: EventSourceMappingSourceAccessConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAccessConfigurations = mapped
    }

    /**
     * @param value The position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs&#46;aws&#46;amazon&#46;com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator&#46;html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
     */
    @JvmName("jqafwvjyqtbhpjpj")
    public suspend fun startingPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    /**
     * @param value A timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
     */
    @JvmName("hhxvhrgllebpgumu")
    public suspend fun startingPositionTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPositionTimestamp = mapped
    }

    /**
     * @param value The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    @JvmName("airihooeifgkoanq")
    public suspend fun topics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param values The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    @JvmName("deqrbbpctnfgbakx")
    public suspend fun topics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param value The duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
     */
    @JvmName("rpmfpnbrqxfnsogd")
    public suspend fun tumblingWindowInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tumblingWindowInSeconds = mapped
    }

    internal fun build(): EventSourceMappingArgs = EventSourceMappingArgs(
        amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig,
        batchSize = batchSize,
        bisectBatchOnFunctionError = bisectBatchOnFunctionError,
        destinationConfig = destinationConfig,
        documentDbEventSourceConfig = documentDbEventSourceConfig,
        enabled = enabled,
        eventSourceArn = eventSourceArn,
        filterCriteria = filterCriteria,
        functionName = functionName,
        functionResponseTypes = functionResponseTypes,
        maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds,
        maximumRecordAgeInSeconds = maximumRecordAgeInSeconds,
        maximumRetryAttempts = maximumRetryAttempts,
        parallelizationFactor = parallelizationFactor,
        queues = queues,
        scalingConfig = scalingConfig,
        selfManagedEventSource = selfManagedEventSource,
        selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig,
        sourceAccessConfigurations = sourceAccessConfigurations,
        startingPosition = startingPosition,
        startingPositionTimestamp = startingPositionTimestamp,
        topics = topics,
        tumblingWindowInSeconds = tumblingWindowInSeconds,
    )
}
