@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs.builder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEventInvokeConfigDestinationConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEventInvokeConfigDestinationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an asynchronous invocation configuration for a Lambda Function or Alias. More information about asynchronous invocations and the configurable values can be found in the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html).
 * ## Example Usage
 * ### Destination Configuration
 * > **NOTE:** Ensure the Lambda Function IAM Role has necessary permissions for the destination, such as `sqs:SendMessage` or `sns:Publish`, otherwise the API will return a generic `InvalidParameterValueException: The destination ARN arn:PARTITION:SERVICE:REGION:ACCOUNT:RESOURCE is invalid.` error.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.FunctionEventInvokeConfig("example", {
 *     functionName: exampleAwsLambdaAlias.functionName,
 *     destinationConfig: {
 *         onFailure: {
 *             destination: exampleAwsSqsQueue.arn,
 *         },
 *         onSuccess: {
 *             destination: exampleAwsSnsTopic.arn,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.FunctionEventInvokeConfig("example",
 *     function_name=example_aws_lambda_alias["functionName"],
 *     destination_config={
 *         "on_failure": {
 *             "destination": example_aws_sqs_queue["arn"],
 *         },
 *         "on_success": {
 *             "destination": example_aws_sns_topic["arn"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.FunctionEventInvokeConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaAlias.FunctionName,
 *         DestinationConfig = new Aws.Lambda.Inputs.FunctionEventInvokeConfigDestinationConfigArgs
 *         {
 *             OnFailure = new Aws.Lambda.Inputs.FunctionEventInvokeConfigDestinationConfigOnFailureArgs
 *             {
 *                 Destination = exampleAwsSqsQueue.Arn,
 *             },
 *             OnSuccess = new Aws.Lambda.Inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs
 *             {
 *                 Destination = exampleAwsSnsTopic.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionEventInvokeConfig(ctx, "example", &lambda.FunctionEventInvokeConfigArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaAlias.FunctionName),
 * 			DestinationConfig: &lambda.FunctionEventInvokeConfigDestinationConfigArgs{
 * 				OnFailure: &lambda.FunctionEventInvokeConfigDestinationConfigOnFailureArgs{
 * 					Destination: pulumi.Any(exampleAwsSqsQueue.Arn),
 * 				},
 * 				OnSuccess: &lambda.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs{
 * 					Destination: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnFailureArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(exampleAwsLambdaAlias.functionName())
 *             .destinationConfig(FunctionEventInvokeConfigDestinationConfigArgs.builder()
 *                 .onFailure(FunctionEventInvokeConfigDestinationConfigOnFailureArgs.builder()
 *                     .destination(exampleAwsSqsQueue.arn())
 *                     .build())
 *                 .onSuccess(FunctionEventInvokeConfigDestinationConfigOnSuccessArgs.builder()
 *                     .destination(exampleAwsSnsTopic.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:FunctionEventInvokeConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaAlias.functionName}
 *       destinationConfig:
 *         onFailure:
 *           destination: ${exampleAwsSqsQueue.arn}
 *         onSuccess:
 *           destination: ${exampleAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Error Handling Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.FunctionEventInvokeConfig("example", {
 *     functionName: exampleAwsLambdaAlias.functionName,
 *     maximumEventAgeInSeconds: 60,
 *     maximumRetryAttempts: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.FunctionEventInvokeConfig("example",
 *     function_name=example_aws_lambda_alias["functionName"],
 *     maximum_event_age_in_seconds=60,
 *     maximum_retry_attempts=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.FunctionEventInvokeConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaAlias.FunctionName,
 *         MaximumEventAgeInSeconds = 60,
 *         MaximumRetryAttempts = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionEventInvokeConfig(ctx, "example", &lambda.FunctionEventInvokeConfigArgs{
 * 			FunctionName:             pulumi.Any(exampleAwsLambdaAlias.FunctionName),
 * 			MaximumEventAgeInSeconds: pulumi.Int(60),
 * 			MaximumRetryAttempts:     pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(exampleAwsLambdaAlias.functionName())
 *             .maximumEventAgeInSeconds(60)
 *             .maximumRetryAttempts(0)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:FunctionEventInvokeConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaAlias.functionName}
 *       maximumEventAgeInSeconds: 60
 *       maximumRetryAttempts: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configuration for Alias Name
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.FunctionEventInvokeConfig("example", {
 *     functionName: exampleAwsLambdaAlias.functionName,
 *     qualifier: exampleAwsLambdaAlias.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.FunctionEventInvokeConfig("example",
 *     function_name=example_aws_lambda_alias["functionName"],
 *     qualifier=example_aws_lambda_alias["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.FunctionEventInvokeConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaAlias.FunctionName,
 *         Qualifier = exampleAwsLambdaAlias.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionEventInvokeConfig(ctx, "example", &lambda.FunctionEventInvokeConfigArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaAlias.FunctionName),
 * 			Qualifier:    pulumi.Any(exampleAwsLambdaAlias.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(exampleAwsLambdaAlias.functionName())
 *             .qualifier(exampleAwsLambdaAlias.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:FunctionEventInvokeConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaAlias.functionName}
 *       qualifier: ${exampleAwsLambdaAlias.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configuration for Function Latest Unpublished Version
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.FunctionEventInvokeConfig("example", {
 *     functionName: exampleAwsLambdaFunction.functionName,
 *     qualifier: "$LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.FunctionEventInvokeConfig("example",
 *     function_name=example_aws_lambda_function["functionName"],
 *     qualifier="$LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.FunctionEventInvokeConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.FunctionName,
 *         Qualifier = "$LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionEventInvokeConfig(ctx, "example", &lambda.FunctionEventInvokeConfigArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaFunction.FunctionName),
 * 			Qualifier:    pulumi.String("$LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.functionName())
 *             .qualifier("$LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:FunctionEventInvokeConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.functionName}
 *       qualifier: $LATEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configuration for Function Published Version
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.FunctionEventInvokeConfig("example", {
 *     functionName: exampleAwsLambdaFunction.functionName,
 *     qualifier: exampleAwsLambdaFunction.version,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.FunctionEventInvokeConfig("example",
 *     function_name=example_aws_lambda_function["functionName"],
 *     qualifier=example_aws_lambda_function["version"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.FunctionEventInvokeConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.FunctionName,
 *         Qualifier = exampleAwsLambdaFunction.Version,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionEventInvokeConfig(ctx, "example", &lambda.FunctionEventInvokeConfigArgs{
 * 			FunctionName: pulumi.Any(exampleAwsLambdaFunction.FunctionName),
 * 			Qualifier:    pulumi.Any(exampleAwsLambdaFunction.Version),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.functionName())
 *             .qualifier(exampleAwsLambdaFunction.version())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:FunctionEventInvokeConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.functionName}
 *       qualifier: ${exampleAwsLambdaFunction.version}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ARN with qualifier:
 * Name without qualifier (all versions and aliases):
 * Name with qualifier:
 * __Using `pulumi import` to import__ Lambda Function Event Invoke Configs using the fully qualified Function name or Amazon Resource Name (ARN). For example:
 * ARN without qualifier (all versions and aliases):
 * ```sh
 * $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:us-east-1:123456789012:function:my_function
 * ```
 * ARN with qualifier:
 * ```sh
 * $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:us-east-1:123456789012:function:my_function:production
 * ```
 * Name without qualifier (all versions and aliases):
 * ```sh
 * $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example my_function
 * ```
 * Name with qualifier:
 * ```sh
 * $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example my_function:production
 * ```
 * @property destinationConfig Configuration block with destination configuration. See below for details.
 * @property functionName Name or Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
 * The following arguments are optional:
 * @property maximumEventAgeInSeconds Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
 * @property maximumRetryAttempts Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
 * @property qualifier Lambda Function published version, `$LATEST`, or Lambda Alias name.
 */
public data class FunctionEventInvokeConfigArgs(
    public val destinationConfig: Output<FunctionEventInvokeConfigDestinationConfigArgs>? = null,
    public val functionName: Output<String>? = null,
    public val maximumEventAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
    public val qualifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs =
        com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs.builder()
            .destinationConfig(destinationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .maximumEventAgeInSeconds(maximumEventAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionEventInvokeConfigArgs].
 */
@PulumiTagMarker
public class FunctionEventInvokeConfigArgsBuilder internal constructor() {
    private var destinationConfig: Output<FunctionEventInvokeConfigDestinationConfigArgs>? = null

    private var functionName: Output<String>? = null

    private var maximumEventAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    private var qualifier: Output<String>? = null

    /**
     * @param value Configuration block with destination configuration. See below for details.
     */
    @JvmName("hycurumkbepfvfru")
    public suspend fun destinationConfig(`value`: Output<FunctionEventInvokeConfigDestinationConfigArgs>) {
        this.destinationConfig = value
    }

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     * The following arguments are optional:
     */
    @JvmName("qafnfqystajnbyhk")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
     */
    @JvmName("chbxcufqkqeekhdp")
    public suspend fun maximumEventAgeInSeconds(`value`: Output<Int>) {
        this.maximumEventAgeInSeconds = value
    }

    /**
     * @param value Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
     */
    @JvmName("xnvdtvrwacvrdvwl")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value Lambda Function published version, `$LATEST`, or Lambda Alias name.
     */
    @JvmName("uajhuonbgrofbjdd")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Configuration block with destination configuration. See below for details.
     */
    @JvmName("phdvoulpbffiwwnt")
    public suspend fun destinationConfig(`value`: FunctionEventInvokeConfigDestinationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfig = mapped
    }

    /**
     * @param argument Configuration block with destination configuration. See below for details.
     */
    @JvmName("haasdpiiojixekgo")
    public suspend fun destinationConfig(argument: suspend FunctionEventInvokeConfigDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionEventInvokeConfigDestinationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfig = mapped
    }

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     * The following arguments are optional:
     */
    @JvmName("qpcwkivtldowrvse")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
     */
    @JvmName("dfklmacuwpjwhivf")
    public suspend fun maximumEventAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumEventAgeInSeconds = mapped
    }

    /**
     * @param value Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
     */
    @JvmName("ddupuxipqhbbhoxn")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    /**
     * @param value Lambda Function published version, `$LATEST`, or Lambda Alias name.
     */
    @JvmName("whbiofefkthygado")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    internal fun build(): FunctionEventInvokeConfigArgs = FunctionEventInvokeConfigArgs(
        destinationConfig = destinationConfig,
        functionName = functionName,
        maximumEventAgeInSeconds = maximumEventAgeInSeconds,
        maximumRetryAttempts = maximumRetryAttempts,
        qualifier = qualifier,
    )
}
