@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.FunctionUrlCors
import com.pulumi.aws.lambda.kotlin.outputs.FunctionUrlCors.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FunctionUrl].
 */
@PulumiTagMarker
public class FunctionUrlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionUrlArgs = FunctionUrlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionUrlArgsBuilder.() -> Unit) {
        val builder = FunctionUrlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FunctionUrl {
        val builtJavaResource = com.pulumi.aws.lambda.FunctionUrl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FunctionUrl(builtJavaResource)
    }
}

/**
 * Provides a Lambda function URL resource. A function URL is a dedicated HTTP(S) endpoint for a Lambda function.
 * See the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-urls.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testLatest = new aws.lambda.FunctionUrl("test_latest", {
 *     functionName: test.functionName,
 *     authorizationType: "NONE",
 * });
 * const testLive = new aws.lambda.FunctionUrl("test_live", {
 *     functionName: test.functionName,
 *     qualifier: "my_alias",
 *     authorizationType: "AWS_IAM",
 *     cors: {
 *         allowCredentials: true,
 *         allowOrigins: ["*"],
 *         allowMethods: ["*"],
 *         allowHeaders: [
 *             "date",
 *             "keep-alive",
 *         ],
 *         exposeHeaders: [
 *             "keep-alive",
 *             "date",
 *         ],
 *         maxAge: 86400,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_latest = aws.lambda_.FunctionUrl("test_latest",
 *     function_name=test["functionName"],
 *     authorization_type="NONE")
 * test_live = aws.lambda_.FunctionUrl("test_live",
 *     function_name=test["functionName"],
 *     qualifier="my_alias",
 *     authorization_type="AWS_IAM",
 *     cors={
 *         "allow_credentials": True,
 *         "allow_origins": ["*"],
 *         "allow_methods": ["*"],
 *         "allow_headers": [
 *             "date",
 *             "keep-alive",
 *         ],
 *         "expose_headers": [
 *             "keep-alive",
 *             "date",
 *         ],
 *         "max_age": 86400,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLatest = new Aws.Lambda.FunctionUrl("test_latest", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         AuthorizationType = "NONE",
 *     });
 *     var testLive = new Aws.Lambda.FunctionUrl("test_live", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         Qualifier = "my_alias",
 *         AuthorizationType = "AWS_IAM",
 *         Cors = new Aws.Lambda.Inputs.FunctionUrlCorsArgs
 *         {
 *             AllowCredentials = true,
 *             AllowOrigins = new[]
 *             {
 *                 "*",
 *             },
 *             AllowMethods = new[]
 *             {
 *                 "*",
 *             },
 *             AllowHeaders = new[]
 *             {
 *                 "date",
 *                 "keep-alive",
 *             },
 *             ExposeHeaders = new[]
 *             {
 *                 "keep-alive",
 *                 "date",
 *             },
 *             MaxAge = 86400,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionUrl(ctx, "test_latest", &lambda.FunctionUrlArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			AuthorizationType: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lambda.NewFunctionUrl(ctx, "test_live", &lambda.FunctionUrlArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			Qualifier:         pulumi.String("my_alias"),
 * 			AuthorizationType: pulumi.String("AWS_IAM"),
 * 			Cors: &lambda.FunctionUrlCorsArgs{
 * 				AllowCredentials: pulumi.Bool(true),
 * 				AllowOrigins: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				AllowMethods: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				AllowHeaders: pulumi.StringArray{
 * 					pulumi.String("date"),
 * 					pulumi.String("keep-alive"),
 * 				},
 * 				ExposeHeaders: pulumi.StringArray{
 * 					pulumi.String("keep-alive"),
 * 					pulumi.String("date"),
 * 				},
 * 				MaxAge: pulumi.Int(86400),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionUrl;
 * import com.pulumi.aws.lambda.FunctionUrlArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLatest = new FunctionUrl("testLatest", FunctionUrlArgs.builder()
 *             .functionName(test.functionName())
 *             .authorizationType("NONE")
 *             .build());
 *         var testLive = new FunctionUrl("testLive", FunctionUrlArgs.builder()
 *             .functionName(test.functionName())
 *             .qualifier("my_alias")
 *             .authorizationType("AWS_IAM")
 *             .cors(FunctionUrlCorsArgs.builder()
 *                 .allowCredentials(true)
 *                 .allowOrigins("*")
 *                 .allowMethods("*")
 *                 .allowHeaders(
 *                     "date",
 *                     "keep-alive")
 *                 .exposeHeaders(
 *                     "keep-alive",
 *                     "date")
 *                 .maxAge(86400)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testLatest:
 *     type: aws:lambda:FunctionUrl
 *     name: test_latest
 *     properties:
 *       functionName: ${test.functionName}
 *       authorizationType: NONE
 *   testLive:
 *     type: aws:lambda:FunctionUrl
 *     name: test_live
 *     properties:
 *       functionName: ${test.functionName}
 *       qualifier: my_alias
 *       authorizationType: AWS_IAM
 *       cors:
 *         allowCredentials: true
 *         allowOrigins:
 *           - '*'
 *         allowMethods:
 *           - '*'
 *         allowHeaders:
 *           - date
 *           - keep-alive
 *         exposeHeaders:
 *           - keep-alive
 *           - date
 *         maxAge: 86400
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:
 * ```sh
 * $ pulumi import aws:lambda/functionUrl:FunctionUrl test_lambda_url my_test_lambda_function
 * ```
 */
public class FunctionUrl internal constructor(
    override val javaResource: com.pulumi.aws.lambda.FunctionUrl,
) : KotlinCustomResource(javaResource, FunctionUrlMapper) {
    /**
     * The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
     */
    public val authorizationType: Output<String>
        get() = javaResource.authorizationType().applyValue({ args0 -> args0 })

    /**
     * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
     */
    public val cors: Output<FunctionUrlCors>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the function.
     */
    public val functionArn: Output<String>
        get() = javaResource.functionArn().applyValue({ args0 -> args0 })

    /**
     * The name (or ARN) of the Lambda function.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * The HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
     */
    public val functionUrl: Output<String>
        get() = javaResource.functionUrl().applyValue({ args0 -> args0 })

    /**
     * Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
     */
    public val invokeMode: Output<String>?
        get() = javaResource.invokeMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The alias name or `"$LATEST"`.
     */
    public val qualifier: Output<String>?
        get() = javaResource.qualifier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A generated ID for the endpoint.
     */
    public val urlId: Output<String>
        get() = javaResource.urlId().applyValue({ args0 -> args0 })
}

public object FunctionUrlMapper : ResourceMapper<FunctionUrl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.FunctionUrl::class == javaResource::class

    override fun map(javaResource: Resource): FunctionUrl = FunctionUrl(
        javaResource as
            com.pulumi.aws.lambda.FunctionUrl,
    )
}

/**
 * @see [FunctionUrl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FunctionUrl].
 */
public suspend fun functionUrl(name: String, block: suspend FunctionUrlResourceBuilder.() -> Unit): FunctionUrl {
    val builder = FunctionUrlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FunctionUrl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun functionUrl(name: String): FunctionUrl {
    val builder = FunctionUrlResourceBuilder()
    builder.name(name)
    return builder.build()
}
