@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.FunctionUrlArgs.builder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionUrlCorsArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionUrlCorsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Lambda function URL resource. A function URL is a dedicated HTTP(S) endpoint for a Lambda function.
 * See the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-urls.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testLatest = new aws.lambda.FunctionUrl("test_latest", {
 *     functionName: test.functionName,
 *     authorizationType: "NONE",
 * });
 * const testLive = new aws.lambda.FunctionUrl("test_live", {
 *     functionName: test.functionName,
 *     qualifier: "my_alias",
 *     authorizationType: "AWS_IAM",
 *     cors: {
 *         allowCredentials: true,
 *         allowOrigins: ["*"],
 *         allowMethods: ["*"],
 *         allowHeaders: [
 *             "date",
 *             "keep-alive",
 *         ],
 *         exposeHeaders: [
 *             "keep-alive",
 *             "date",
 *         ],
 *         maxAge: 86400,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_latest = aws.lambda_.FunctionUrl("test_latest",
 *     function_name=test["functionName"],
 *     authorization_type="NONE")
 * test_live = aws.lambda_.FunctionUrl("test_live",
 *     function_name=test["functionName"],
 *     qualifier="my_alias",
 *     authorization_type="AWS_IAM",
 *     cors={
 *         "allow_credentials": True,
 *         "allow_origins": ["*"],
 *         "allow_methods": ["*"],
 *         "allow_headers": [
 *             "date",
 *             "keep-alive",
 *         ],
 *         "expose_headers": [
 *             "keep-alive",
 *             "date",
 *         ],
 *         "max_age": 86400,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLatest = new Aws.Lambda.FunctionUrl("test_latest", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         AuthorizationType = "NONE",
 *     });
 *     var testLive = new Aws.Lambda.FunctionUrl("test_live", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         Qualifier = "my_alias",
 *         AuthorizationType = "AWS_IAM",
 *         Cors = new Aws.Lambda.Inputs.FunctionUrlCorsArgs
 *         {
 *             AllowCredentials = true,
 *             AllowOrigins = new[]
 *             {
 *                 "*",
 *             },
 *             AllowMethods = new[]
 *             {
 *                 "*",
 *             },
 *             AllowHeaders = new[]
 *             {
 *                 "date",
 *                 "keep-alive",
 *             },
 *             ExposeHeaders = new[]
 *             {
 *                 "keep-alive",
 *                 "date",
 *             },
 *             MaxAge = 86400,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewFunctionUrl(ctx, "test_latest", &lambda.FunctionUrlArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			AuthorizationType: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lambda.NewFunctionUrl(ctx, "test_live", &lambda.FunctionUrlArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			Qualifier:         pulumi.String("my_alias"),
 * 			AuthorizationType: pulumi.String("AWS_IAM"),
 * 			Cors: &lambda.FunctionUrlCorsArgs{
 * 				AllowCredentials: pulumi.Bool(true),
 * 				AllowOrigins: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				AllowMethods: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				AllowHeaders: pulumi.StringArray{
 * 					pulumi.String("date"),
 * 					pulumi.String("keep-alive"),
 * 				},
 * 				ExposeHeaders: pulumi.StringArray{
 * 					pulumi.String("keep-alive"),
 * 					pulumi.String("date"),
 * 				},
 * 				MaxAge: pulumi.Int(86400),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionUrl;
 * import com.pulumi.aws.lambda.FunctionUrlArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLatest = new FunctionUrl("testLatest", FunctionUrlArgs.builder()
 *             .functionName(test.functionName())
 *             .authorizationType("NONE")
 *             .build());
 *         var testLive = new FunctionUrl("testLive", FunctionUrlArgs.builder()
 *             .functionName(test.functionName())
 *             .qualifier("my_alias")
 *             .authorizationType("AWS_IAM")
 *             .cors(FunctionUrlCorsArgs.builder()
 *                 .allowCredentials(true)
 *                 .allowOrigins("*")
 *                 .allowMethods("*")
 *                 .allowHeaders(
 *                     "date",
 *                     "keep-alive")
 *                 .exposeHeaders(
 *                     "keep-alive",
 *                     "date")
 *                 .maxAge(86400)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testLatest:
 *     type: aws:lambda:FunctionUrl
 *     name: test_latest
 *     properties:
 *       functionName: ${test.functionName}
 *       authorizationType: NONE
 *   testLive:
 *     type: aws:lambda:FunctionUrl
 *     name: test_live
 *     properties:
 *       functionName: ${test.functionName}
 *       qualifier: my_alias
 *       authorizationType: AWS_IAM
 *       cors:
 *         allowCredentials: true
 *         allowOrigins:
 *           - '*'
 *         allowMethods:
 *           - '*'
 *         allowHeaders:
 *           - date
 *           - keep-alive
 *         exposeHeaders:
 *           - keep-alive
 *           - date
 *         maxAge: 86400
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:
 * ```sh
 * $ pulumi import aws:lambda/functionUrl:FunctionUrl test_lambda_url my_test_lambda_function
 * ```
 * @property authorizationType The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
 * @property cors The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
 * @property functionName The name (or ARN) of the Lambda function.
 * @property invokeMode Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
 * @property qualifier The alias name or `"$LATEST"`.
 */
public data class FunctionUrlArgs(
    public val authorizationType: Output<String>? = null,
    public val cors: Output<FunctionUrlCorsArgs>? = null,
    public val functionName: Output<String>? = null,
    public val invokeMode: Output<String>? = null,
    public val qualifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.FunctionUrlArgs> {
    override fun toJava(): com.pulumi.aws.lambda.FunctionUrlArgs =
        com.pulumi.aws.lambda.FunctionUrlArgs.builder()
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .invokeMode(invokeMode?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionUrlArgs].
 */
@PulumiTagMarker
public class FunctionUrlArgsBuilder internal constructor() {
    private var authorizationType: Output<String>? = null

    private var cors: Output<FunctionUrlCorsArgs>? = null

    private var functionName: Output<String>? = null

    private var invokeMode: Output<String>? = null

    private var qualifier: Output<String>? = null

    /**
     * @param value The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
     */
    @JvmName("qbdcexqyojrueskq")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
     */
    @JvmName("jgiqmsyokubpeybg")
    public suspend fun cors(`value`: Output<FunctionUrlCorsArgs>) {
        this.cors = value
    }

    /**
     * @param value The name (or ARN) of the Lambda function.
     */
    @JvmName("gxlwhluhxwnergcq")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
     */
    @JvmName("ptppqbfkxrtocxiv")
    public suspend fun invokeMode(`value`: Output<String>) {
        this.invokeMode = value
    }

    /**
     * @param value The alias name or `"$LATEST"`.
     */
    @JvmName("rfiqouedwtynrfri")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
     */
    @JvmName("endlwyvqqkcdebbo")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
     */
    @JvmName("leacqgkahdugrtra")
    public suspend fun cors(`value`: FunctionUrlCorsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
     */
    @JvmName("ymrulsywbxcfhqvo")
    public suspend fun cors(argument: suspend FunctionUrlCorsArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionUrlCorsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value The name (or ARN) of the Lambda function.
     */
    @JvmName("mbpxfkunnrnecdno")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
     */
    @JvmName("oaxpujqsojwewxdb")
    public suspend fun invokeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invokeMode = mapped
    }

    /**
     * @param value The alias name or `"$LATEST"`.
     */
    @JvmName("ebxyugavdermfald")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    internal fun build(): FunctionUrlArgs = FunctionUrlArgs(
        authorizationType = authorizationType,
        cors = cors,
        functionName = functionName,
        invokeMode = invokeMode,
        qualifier = qualifier,
    )
}
