@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.LambdaFunctions.getAliasPlain
import com.pulumi.aws.lambda.LambdaFunctions.getCodeSigningConfigPlain
import com.pulumi.aws.lambda.LambdaFunctions.getFunctionPlain
import com.pulumi.aws.lambda.LambdaFunctions.getFunctionUrlPlain
import com.pulumi.aws.lambda.LambdaFunctions.getFunctionsPlain
import com.pulumi.aws.lambda.LambdaFunctions.getInvocationPlain
import com.pulumi.aws.lambda.LambdaFunctions.getLayerVersionPlain
import com.pulumi.aws.lambda.kotlin.inputs.GetAliasPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetAliasPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.GetCodeSigningConfigPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetCodeSigningConfigPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.GetFunctionPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetFunctionPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.GetFunctionUrlPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetFunctionUrlPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.GetInvocationPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetInvocationPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.GetLayerVersionPlainArgs
import com.pulumi.aws.lambda.kotlin.inputs.GetLayerVersionPlainArgsBuilder
import com.pulumi.aws.lambda.kotlin.outputs.GetAliasResult
import com.pulumi.aws.lambda.kotlin.outputs.GetCodeSigningConfigResult
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionResult
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionUrlResult
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionsResult
import com.pulumi.aws.lambda.kotlin.outputs.GetInvocationResult
import com.pulumi.aws.lambda.kotlin.outputs.GetLayerVersionResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.lambda.kotlin.outputs.GetAliasResult.Companion.toKotlin as getAliasResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetCodeSigningConfigResult.Companion.toKotlin as getCodeSigningConfigResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionResult.Companion.toKotlin as getFunctionResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionUrlResult.Companion.toKotlin as getFunctionUrlResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetFunctionsResult.Companion.toKotlin as getFunctionsResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetInvocationResult.Companion.toKotlin as getInvocationResultToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.GetLayerVersionResult.Companion.toKotlin as getLayerVersionResultToKotlin

public object LambdaFunctions {
    /**
     * Provides information about a Lambda Alias.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const production = aws.lambda.getAlias({
     *     functionName: "my-lambda-func",
     *     name: "production",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * production = aws.lambda.get_alias(function_name="my-lambda-func",
     *     name="production")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var production = Aws.Lambda.GetAlias.Invoke(new()
     *     {
     *         FunctionName = "my-lambda-func",
     *         Name = "production",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lambda.LookupAlias(ctx, &lambda.LookupAliasArgs{
     * 			FunctionName: "my-lambda-func",
     * 			Name:         "production",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import com.pulumi.aws.lambda.inputs.GetAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var production = LambdaFunctions.getAlias(GetAliasArgs.builder()
     *             .functionName("my-lambda-func")
     *             .name("production")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   production:
     *     fn::invoke:
     *       Function: aws:lambda:getAlias
     *       Arguments:
     *         functionName: my-lambda-func
     *         name: production
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlias.
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: GetAliasPlainArgs): GetAliasResult =
        getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())

    /**
     * @see [getAlias].
     * @param functionName Name of the aliased Lambda function.
     * @param name Name of the Lambda alias.
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(functionName: String, name: String): GetAliasResult {
        val argument = GetAliasPlainArgs(
            functionName = functionName,
            name = name,
        )
        return getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlias].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetAliasPlainArgs].
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: suspend GetAliasPlainArgsBuilder.() -> Unit): GetAliasResult {
        val builder = GetAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAliasResultToKotlin(getAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Lambda Code Signing Config. A code signing configuration defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
     * For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const existingCsc = aws.lambda.getCodeSigningConfig({
     *     arn: `arn:aws:lambda:${awsRegion}:${awsAccount}:code-signing-config:csc-0f6c334abcdea4d8b`,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * existing_csc = aws.lambda.get_code_signing_config(arn=f"arn:aws:lambda:{aws_region}:{aws_account}:code-signing-config:csc-0f6c334abcdea4d8b")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var existingCsc = Aws.Lambda.GetCodeSigningConfig.Invoke(new()
     *     {
     *         Arn = $"arn:aws:lambda:{awsRegion}:{awsAccount}:code-signing-config:csc-0f6c334abcdea4d8b",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lambda.LookupCodeSigningConfig(ctx, &lambda.LookupCodeSigningConfigArgs{
     * 			Arn: fmt.Sprintf("arn:aws:lambda:%v:%v:code-signing-config:csc-0f6c334abcdea4d8b", awsRegion, awsAccount),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import com.pulumi.aws.lambda.inputs.GetCodeSigningConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var existingCsc = LambdaFunctions.getCodeSigningConfig(GetCodeSigningConfigArgs.builder()
     *             .arn(String.format("arn:aws:lambda:%s:%s:code-signing-config:csc-0f6c334abcdea4d8b", awsRegion,awsAccount))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   existingCsc:
     *     fn::invoke:
     *       Function: aws:lambda:getCodeSigningConfig
     *       Arguments:
     *         arn: arn:aws:lambda:${awsRegion}:${awsAccount}:code-signing-config:csc-0f6c334abcdea4d8b
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCodeSigningConfig.
     * @return A collection of values returned by getCodeSigningConfig.
     */
    public suspend fun getCodeSigningConfig(argument: GetCodeSigningConfigPlainArgs): GetCodeSigningConfigResult =
        getCodeSigningConfigResultToKotlin(getCodeSigningConfigPlain(argument.toJava()).await())

    /**
     * @see [getCodeSigningConfig].
     * @param arn ARN of the code signing configuration.
     * @return A collection of values returned by getCodeSigningConfig.
     */
    public suspend fun getCodeSigningConfig(arn: String): GetCodeSigningConfigResult {
        val argument = GetCodeSigningConfigPlainArgs(
            arn = arn,
        )
        return getCodeSigningConfigResultToKotlin(getCodeSigningConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getCodeSigningConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetCodeSigningConfigPlainArgs].
     * @return A collection of values returned by getCodeSigningConfig.
     */
    public suspend fun getCodeSigningConfig(argument: suspend GetCodeSigningConfigPlainArgsBuilder.() -> Unit): GetCodeSigningConfigResult {
        val builder = GetCodeSigningConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCodeSigningConfigResultToKotlin(getCodeSigningConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Lambda Function.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const functionName = config.require("functionName");
     * const existing = aws.lambda.getFunction({
     *     functionName: functionName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * function_name = config.require("functionName")
     * existing = aws.lambda.get_function(function_name=function_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var functionName = config.Require("functionName");
     *     var existing = Aws.Lambda.GetFunction.Invoke(new()
     *     {
     *         FunctionName = functionName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		functionName := cfg.Require("functionName")
     * 		_, err := lambda.LookupFunction(ctx, &lambda.LookupFunctionArgs{
     * 			FunctionName: functionName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import com.pulumi.aws.lambda.inputs.GetFunctionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var functionName = config.get("functionName");
     *         final var existing = LambdaFunctions.getFunction(GetFunctionArgs.builder()
     *             .functionName(functionName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   functionName:
     *     type: string
     * variables:
     *   existing:
     *     fn::invoke:
     *       Function: aws:lambda:getFunction
     *       Arguments:
     *         functionName: ${functionName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFunction.
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: GetFunctionPlainArgs): GetFunctionResult =
        getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())

    /**
     * @see [getFunction].
     * @param functionName Name of the lambda function.
     * @param qualifier Alias name or version number of the lambda functionE.g., `$LATEST`, `my-alias`, or `1`. When not included: the data source resolves to the most recent published version; if no published version exists: it resolves to the most recent unpublished version.
     * @param tags
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(
        functionName: String,
        qualifier: String? = null,
        tags: Map<String, String>? = null,
    ): GetFunctionResult {
        val argument = GetFunctionPlainArgs(
            functionName = functionName,
            qualifier = qualifier,
            tags = tags,
        )
        return getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getFunction].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetFunctionPlainArgs].
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: suspend GetFunctionPlainArgsBuilder.() -> Unit): GetFunctionResult {
        val builder = GetFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFunctionResultToKotlin(getFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Lambda function URL.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const functionName = config.require("functionName");
     * const existing = aws.lambda.getFunctionUrl({
     *     functionName: functionName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * function_name = config.require("functionName")
     * existing = aws.lambda.get_function_url(function_name=function_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var functionName = config.Require("functionName");
     *     var existing = Aws.Lambda.GetFunctionUrl.Invoke(new()
     *     {
     *         FunctionName = functionName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		functionName := cfg.Require("functionName")
     * 		_, err := lambda.LookupFunctionUrl(ctx, &lambda.LookupFunctionUrlArgs{
     * 			FunctionName: functionName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import com.pulumi.aws.lambda.inputs.GetFunctionUrlArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var functionName = config.get("functionName");
     *         final var existing = LambdaFunctions.getFunctionUrl(GetFunctionUrlArgs.builder()
     *             .functionName(functionName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   functionName:
     *     type: string
     * variables:
     *   existing:
     *     fn::invoke:
     *       Function: aws:lambda:getFunctionUrl
     *       Arguments:
     *         functionName: ${functionName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFunctionUrl.
     * @return A collection of values returned by getFunctionUrl.
     */
    public suspend fun getFunctionUrl(argument: GetFunctionUrlPlainArgs): GetFunctionUrlResult =
        getFunctionUrlResultToKotlin(getFunctionUrlPlain(argument.toJava()).await())

    /**
     * @see [getFunctionUrl].
     * @param functionName The name (or ARN) of the Lambda function.
     * @param qualifier Alias name or `"$LATEST"`.
     * @return A collection of values returned by getFunctionUrl.
     */
    public suspend fun getFunctionUrl(functionName: String, qualifier: String? = null): GetFunctionUrlResult {
        val argument = GetFunctionUrlPlainArgs(
            functionName = functionName,
            qualifier = qualifier,
        )
        return getFunctionUrlResultToKotlin(getFunctionUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getFunctionUrl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetFunctionUrlPlainArgs].
     * @return A collection of values returned by getFunctionUrl.
     */
    public suspend fun getFunctionUrl(argument: suspend GetFunctionUrlPlainArgsBuilder.() -> Unit): GetFunctionUrlResult {
        val builder = GetFunctionUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFunctionUrlResultToKotlin(getFunctionUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Data resource to get a list of Lambda Functions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const all = aws.lambda.getFunctions({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * all = aws.lambda.get_functions()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = Aws.Lambda.GetFunctions.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lambda.GetFunctions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = LambdaFunctions.getFunctions();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: aws:lambda:getFunctions
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Data resource to get a list of Lambda Functions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const all = aws.lambda.getFunctions({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * all = aws.lambda.get_functions()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = Aws.Lambda.GetFunctions.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lambda.GetFunctions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = LambdaFunctions.getFunctions();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: aws:lambda:getFunctions
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getFunctions.
     */
    public suspend fun getFunctions(): GetFunctionsResult =
        getFunctionsResultToKotlin(getFunctionsPlain().await())

    /**
     * Use this data source to invoke custom lambda functions as data source.
     * The lambda function is invoked with [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax)
     * invocation type.
     * > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `aws.lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)
     * @param argument A collection of arguments for invoking getInvocation.
     * @return A collection of values returned by getInvocation.
     */
    public suspend fun getInvocation(argument: GetInvocationPlainArgs): GetInvocationResult =
        getInvocationResultToKotlin(getInvocationPlain(argument.toJava()).await())

    /**
     * @see [getInvocation].
     * @param functionName Name of the lambda function.
     * @param input String in JSON format that is passed as payload to the lambda function.
     * @param qualifier Qualifier (a.k.a version) of the lambda function. Defaults
     * to `$LATEST`.
     * @return A collection of values returned by getInvocation.
     */
    public suspend fun getInvocation(
        functionName: String,
        input: String,
        qualifier: String? = null,
    ): GetInvocationResult {
        val argument = GetInvocationPlainArgs(
            functionName = functionName,
            input = input,
            qualifier = qualifier,
        )
        return getInvocationResultToKotlin(getInvocationPlain(argument.toJava()).await())
    }

    /**
     * @see [getInvocation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetInvocationPlainArgs].
     * @return A collection of values returned by getInvocation.
     */
    public suspend fun getInvocation(argument: suspend GetInvocationPlainArgsBuilder.() -> Unit): GetInvocationResult {
        val builder = GetInvocationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInvocationResultToKotlin(getInvocationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Lambda Layer Version.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const layerName = config.require("layerName");
     * const existing = aws.lambda.getLayerVersion({
     *     layerName: layerName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * layer_name = config.require("layerName")
     * existing = aws.lambda.get_layer_version(layer_name=layer_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var layerName = config.Require("layerName");
     *     var existing = Aws.Lambda.GetLayerVersion.Invoke(new()
     *     {
     *         LayerName = layerName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		layerName := cfg.Require("layerName")
     * 		_, err := lambda.LookupLayerVersion(ctx, &lambda.LookupLayerVersionArgs{
     * 			LayerName: layerName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lambda.LambdaFunctions;
     * import com.pulumi.aws.lambda.inputs.GetLayerVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var layerName = config.get("layerName");
     *         final var existing = LambdaFunctions.getLayerVersion(GetLayerVersionArgs.builder()
     *             .layerName(layerName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   layerName:
     *     type: string
     * variables:
     *   existing:
     *     fn::invoke:
     *       Function: aws:lambda:getLayerVersion
     *       Arguments:
     *         layerName: ${layerName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLayerVersion.
     * @return A collection of values returned by getLayerVersion.
     */
    public suspend fun getLayerVersion(argument: GetLayerVersionPlainArgs): GetLayerVersionResult =
        getLayerVersionResultToKotlin(getLayerVersionPlain(argument.toJava()).await())

    /**
     * @see [getLayerVersion].
     * @param compatibleArchitecture Specific architecture the layer version could support. Conflicts with `version`. If specified, the latest available layer version supporting the provided architecture will be used.
     * @param compatibleRuntime Specific runtime the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided runtime will be used.
     * @param layerName Name of the lambda layer.
     * @param version Specific layer version. Conflicts with `compatible_runtime` and `compatible_architecture`. If omitted, the latest available layer version will be used.
     * @return A collection of values returned by getLayerVersion.
     */
    public suspend fun getLayerVersion(
        compatibleArchitecture: String? = null,
        compatibleRuntime: String? = null,
        layerName: String,
        version: Int? = null,
    ): GetLayerVersionResult {
        val argument = GetLayerVersionPlainArgs(
            compatibleArchitecture = compatibleArchitecture,
            compatibleRuntime = compatibleRuntime,
            layerName = layerName,
            version = version,
        )
        return getLayerVersionResultToKotlin(getLayerVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getLayerVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lambda&#46;kotlin&#46;inputs&#46;GetLayerVersionPlainArgs].
     * @return A collection of values returned by getLayerVersion.
     */
    public suspend fun getLayerVersion(argument: suspend GetLayerVersionPlainArgsBuilder.() -> Unit): GetLayerVersionResult {
        val builder = GetLayerVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLayerVersionResultToKotlin(getLayerVersionPlain(builtArgument.toJava()).await())
    }
}
