@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.LayerVersionPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Lambda Layer Version Permission resource. It allows you to share you own Lambda Layers to another account by account ID, to all accounts in AWS organization or even to all AWS accounts.
 * For information about Lambda Layer Permissions and how to use them, see [Using Resource-based Policies for AWS Lambda][1]
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy any layer version permission, even when running `pulumi destroy`. Layer version permissions are thus intentional dangling resources that are _not_ managed by Pulumi and may incur extra expense in your AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lambdaLayerPermission = new aws.lambda.LayerVersionPermission("lambda_layer_permission", {
 *     layerName: "arn:aws:lambda:us-west-2:123456654321:layer:test_layer1",
 *     versionNumber: 1,
 *     principal: "111111111111",
 *     action: "lambda:GetLayerVersion",
 *     statementId: "dev-account",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lambda_layer_permission = aws.lambda_.LayerVersionPermission("lambda_layer_permission",
 *     layer_name="arn:aws:lambda:us-west-2:123456654321:layer:test_layer1",
 *     version_number=1,
 *     principal="111111111111",
 *     action="lambda:GetLayerVersion",
 *     statement_id="dev-account")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lambdaLayerPermission = new Aws.Lambda.LayerVersionPermission("lambda_layer_permission", new()
 *     {
 *         LayerName = "arn:aws:lambda:us-west-2:123456654321:layer:test_layer1",
 *         VersionNumber = 1,
 *         Principal = "111111111111",
 *         Action = "lambda:GetLayerVersion",
 *         StatementId = "dev-account",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewLayerVersionPermission(ctx, "lambda_layer_permission", &lambda.LayerVersionPermissionArgs{
 * 			LayerName:     pulumi.String("arn:aws:lambda:us-west-2:123456654321:layer:test_layer1"),
 * 			VersionNumber: pulumi.Int(1),
 * 			Principal:     pulumi.String("111111111111"),
 * 			Action:        pulumi.String("lambda:GetLayerVersion"),
 * 			StatementId:   pulumi.String("dev-account"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersionPermission;
 * import com.pulumi.aws.lambda.LayerVersionPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambdaLayerPermission = new LayerVersionPermission("lambdaLayerPermission", LayerVersionPermissionArgs.builder()
 *             .layerName("arn:aws:lambda:us-west-2:123456654321:layer:test_layer1")
 *             .versionNumber(1)
 *             .principal("111111111111")
 *             .action("lambda:GetLayerVersion")
 *             .statementId("dev-account")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lambdaLayerPermission:
 *     type: aws:lambda:LayerVersionPermission
 *     name: lambda_layer_permission
 *     properties:
 *       layerName: arn:aws:lambda:us-west-2:123456654321:layer:test_layer1
 *       versionNumber: 1
 *       principal: '111111111111'
 *       action: lambda:GetLayerVersion
 *       statementId: dev-account
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lambda Layer Permissions using `layer_name` and `version_number`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:lambda/layerVersionPermission:LayerVersionPermission example arn:aws:lambda:us-west-2:123456654321:layer:test_layer1,1
 * ```
 * @property action Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
 * @property layerName The name or ARN of the Lambda Layer, which you want to grant access to.
 * @property organizationId An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
 * @property principal AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
 * @property skipDestroy Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
 * @property statementId The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
 * @property versionNumber Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
 */
public data class LayerVersionPermissionArgs(
    public val action: Output<String>? = null,
    public val layerName: Output<String>? = null,
    public val organizationId: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val statementId: Output<String>? = null,
    public val versionNumber: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.LayerVersionPermissionArgs> {
    override fun toJava(): com.pulumi.aws.lambda.LayerVersionPermissionArgs =
        com.pulumi.aws.lambda.LayerVersionPermissionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .layerName(layerName?.applyValue({ args0 -> args0 }))
            .organizationId(organizationId?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .statementId(statementId?.applyValue({ args0 -> args0 }))
            .versionNumber(versionNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LayerVersionPermissionArgs].
 */
@PulumiTagMarker
public class LayerVersionPermissionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var layerName: Output<String>? = null

    private var organizationId: Output<String>? = null

    private var principal: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var statementId: Output<String>? = null

    private var versionNumber: Output<Int>? = null

    /**
     * @param value Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
     */
    @JvmName("nvkumvnqdwlpmolk")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The name or ARN of the Lambda Layer, which you want to grant access to.
     */
    @JvmName("cmvylwfcmtgpngiy")
    public suspend fun layerName(`value`: Output<String>) {
        this.layerName = value
    }

    /**
     * @param value An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
     */
    @JvmName("lxdodciaxrndbvib")
    public suspend fun organizationId(`value`: Output<String>) {
        this.organizationId = value
    }

    /**
     * @param value AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
     */
    @JvmName("gcqlehsxigvddphr")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("jlkuhppdnigfrrsw")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
     */
    @JvmName("wpyxyxqrckhgvjxh")
    public suspend fun statementId(`value`: Output<String>) {
        this.statementId = value
    }

    /**
     * @param value Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
     */
    @JvmName("kljcqwllqmxdhici")
    public suspend fun versionNumber(`value`: Output<Int>) {
        this.versionNumber = value
    }

    /**
     * @param value Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
     */
    @JvmName("vtnsuvfcctlgikff")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The name or ARN of the Lambda Layer, which you want to grant access to.
     */
    @JvmName("gepbjgvvykqkutfg")
    public suspend fun layerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layerName = mapped
    }

    /**
     * @param value An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
     */
    @JvmName("plxkmrkhhnrbpfks")
    public suspend fun organizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationId = mapped
    }

    /**
     * @param value AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
     */
    @JvmName("qfrlohqyykakwsbt")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("tlsyhcffevkjbkku")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
     */
    @JvmName("pvaysulkneenvupq")
    public suspend fun statementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementId = mapped
    }

    /**
     * @param value Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
     */
    @JvmName("dpqatlmcvqywdwyx")
    public suspend fun versionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionNumber = mapped
    }

    internal fun build(): LayerVersionPermissionArgs = LayerVersionPermissionArgs(
        action = action,
        layerName = layerName,
        organizationId = organizationId,
        principal = principal,
        skipDestroy = skipDestroy,
        statementId = statementId,
        versionNumber = versionNumber,
    )
}
