@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProvisionedConcurrencyConfig].
 */
@PulumiTagMarker
public class ProvisionedConcurrencyConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisionedConcurrencyConfigArgs = ProvisionedConcurrencyConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisionedConcurrencyConfigArgsBuilder.() -> Unit) {
        val builder = ProvisionedConcurrencyConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisionedConcurrencyConfig {
        val builtJavaResource =
            com.pulumi.aws.lambda.ProvisionedConcurrencyConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisionedConcurrencyConfig(builtJavaResource)
    }
}

/**
 * Manages a Lambda Provisioned Concurrency Configuration.
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy a provisioned concurrency configuration, even when running `pulumi destroy`. The configuration is thus an intentional dangling resource that is _not_ managed by Pulumi and may incur extra expense in your AWS account.
 * ## Example Usage
 * ### Alias Name
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.ProvisionedConcurrencyConfig("example", {
 *     functionName: exampleAwsLambdaAlias.functionName,
 *     provisionedConcurrentExecutions: 1,
 *     qualifier: exampleAwsLambdaAlias.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.ProvisionedConcurrencyConfig("example",
 *     function_name=example_aws_lambda_alias["functionName"],
 *     provisioned_concurrent_executions=1,
 *     qualifier=example_aws_lambda_alias["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.ProvisionedConcurrencyConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaAlias.FunctionName,
 *         ProvisionedConcurrentExecutions = 1,
 *         Qualifier = exampleAwsLambdaAlias.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewProvisionedConcurrencyConfig(ctx, "example", &lambda.ProvisionedConcurrencyConfigArgs{
 * 			FunctionName:                    pulumi.Any(exampleAwsLambdaAlias.FunctionName),
 * 			ProvisionedConcurrentExecutions: pulumi.Int(1),
 * 			Qualifier:                       pulumi.Any(exampleAwsLambdaAlias.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(exampleAwsLambdaAlias.functionName())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(exampleAwsLambdaAlias.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:ProvisionedConcurrencyConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaAlias.functionName}
 *       provisionedConcurrentExecutions: 1
 *       qualifier: ${exampleAwsLambdaAlias.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Function Version
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.ProvisionedConcurrencyConfig("example", {
 *     functionName: exampleAwsLambdaFunction.functionName,
 *     provisionedConcurrentExecutions: 1,
 *     qualifier: exampleAwsLambdaFunction.version,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.ProvisionedConcurrencyConfig("example",
 *     function_name=example_aws_lambda_function["functionName"],
 *     provisioned_concurrent_executions=1,
 *     qualifier=example_aws_lambda_function["version"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.ProvisionedConcurrencyConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.FunctionName,
 *         ProvisionedConcurrentExecutions = 1,
 *         Qualifier = exampleAwsLambdaFunction.Version,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewProvisionedConcurrencyConfig(ctx, "example", &lambda.ProvisionedConcurrencyConfigArgs{
 * 			FunctionName:                    pulumi.Any(exampleAwsLambdaFunction.FunctionName),
 * 			ProvisionedConcurrentExecutions: pulumi.Int(1),
 * 			Qualifier:                       pulumi.Any(exampleAwsLambdaFunction.Version),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.functionName())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(exampleAwsLambdaFunction.version())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:ProvisionedConcurrencyConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.functionName}
 *       provisionedConcurrentExecutions: 1
 *       qualifier: ${exampleAwsLambdaFunction.version}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a Lambda Provisioned Concurrency Configuration using the `function_name` and `qualifier` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:lambda/provisionedConcurrencyConfig:ProvisionedConcurrencyConfig example my_function,production
 * ```
 */
public class ProvisionedConcurrencyConfig internal constructor(
    override val javaResource: com.pulumi.aws.lambda.ProvisionedConcurrencyConfig,
) : KotlinCustomResource(javaResource, ProvisionedConcurrencyConfigMapper) {
    /**
     * Name or Amazon Resource Name (ARN) of the Lambda Function.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Amount of capacity to allocate. Must be greater than or equal to `1`.
     */
    public val provisionedConcurrentExecutions: Output<Int>
        get() = javaResource.provisionedConcurrentExecutions().applyValue({ args0 -> args0 })

    /**
     * Lambda Function version or Lambda Alias name.
     * The following arguments are optional:
     */
    public val qualifier: Output<String>
        get() = javaResource.qualifier().applyValue({ args0 -> args0 })

    /**
     * Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ProvisionedConcurrencyConfigMapper : ResourceMapper<ProvisionedConcurrencyConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.ProvisionedConcurrencyConfig::class == javaResource::class

    override fun map(javaResource: Resource): ProvisionedConcurrencyConfig =
        ProvisionedConcurrencyConfig(
            javaResource as
                com.pulumi.aws.lambda.ProvisionedConcurrencyConfig,
        )
}

/**
 * @see [ProvisionedConcurrencyConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisionedConcurrencyConfig].
 */
public suspend fun provisionedConcurrencyConfig(
    name: String,
    block: suspend ProvisionedConcurrencyConfigResourceBuilder.() -> Unit,
): ProvisionedConcurrencyConfig {
    val builder = ProvisionedConcurrencyConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisionedConcurrencyConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisionedConcurrencyConfig(name: String): ProvisionedConcurrencyConfig {
    val builder = ProvisionedConcurrencyConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
