@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Lambda Provisioned Concurrency Configuration.
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy a provisioned concurrency configuration, even when running `pulumi destroy`. The configuration is thus an intentional dangling resource that is _not_ managed by Pulumi and may incur extra expense in your AWS account.
 * ## Example Usage
 * ### Alias Name
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.ProvisionedConcurrencyConfig("example", {
 *     functionName: exampleAwsLambdaAlias.functionName,
 *     provisionedConcurrentExecutions: 1,
 *     qualifier: exampleAwsLambdaAlias.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.ProvisionedConcurrencyConfig("example",
 *     function_name=example_aws_lambda_alias["functionName"],
 *     provisioned_concurrent_executions=1,
 *     qualifier=example_aws_lambda_alias["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.ProvisionedConcurrencyConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaAlias.FunctionName,
 *         ProvisionedConcurrentExecutions = 1,
 *         Qualifier = exampleAwsLambdaAlias.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewProvisionedConcurrencyConfig(ctx, "example", &lambda.ProvisionedConcurrencyConfigArgs{
 * 			FunctionName:                    pulumi.Any(exampleAwsLambdaAlias.FunctionName),
 * 			ProvisionedConcurrentExecutions: pulumi.Int(1),
 * 			Qualifier:                       pulumi.Any(exampleAwsLambdaAlias.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(exampleAwsLambdaAlias.functionName())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(exampleAwsLambdaAlias.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:ProvisionedConcurrencyConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaAlias.functionName}
 *       provisionedConcurrentExecutions: 1
 *       qualifier: ${exampleAwsLambdaAlias.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Function Version
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.ProvisionedConcurrencyConfig("example", {
 *     functionName: exampleAwsLambdaFunction.functionName,
 *     provisionedConcurrentExecutions: 1,
 *     qualifier: exampleAwsLambdaFunction.version,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.ProvisionedConcurrencyConfig("example",
 *     function_name=example_aws_lambda_function["functionName"],
 *     provisioned_concurrent_executions=1,
 *     qualifier=example_aws_lambda_function["version"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.ProvisionedConcurrencyConfig("example", new()
 *     {
 *         FunctionName = exampleAwsLambdaFunction.FunctionName,
 *         ProvisionedConcurrentExecutions = 1,
 *         Qualifier = exampleAwsLambdaFunction.Version,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewProvisionedConcurrencyConfig(ctx, "example", &lambda.ProvisionedConcurrencyConfigArgs{
 * 			FunctionName:                    pulumi.Any(exampleAwsLambdaFunction.FunctionName),
 * 			ProvisionedConcurrentExecutions: pulumi.Int(1),
 * 			Qualifier:                       pulumi.Any(exampleAwsLambdaFunction.Version),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(exampleAwsLambdaFunction.functionName())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(exampleAwsLambdaFunction.version())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:ProvisionedConcurrencyConfig
 *     properties:
 *       functionName: ${exampleAwsLambdaFunction.functionName}
 *       provisionedConcurrentExecutions: 1
 *       qualifier: ${exampleAwsLambdaFunction.version}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a Lambda Provisioned Concurrency Configuration using the `function_name` and `qualifier` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:lambda/provisionedConcurrencyConfig:ProvisionedConcurrencyConfig example my_function,production
 * ```
 * @property functionName Name or Amazon Resource Name (ARN) of the Lambda Function.
 * @property provisionedConcurrentExecutions Amount of capacity to allocate. Must be greater than or equal to `1`.
 * @property qualifier Lambda Function version or Lambda Alias name.
 * The following arguments are optional:
 * @property skipDestroy Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
 */
public data class ProvisionedConcurrencyConfigArgs(
    public val functionName: Output<String>? = null,
    public val provisionedConcurrentExecutions: Output<Int>? = null,
    public val qualifier: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs =
        com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .provisionedConcurrentExecutions(provisionedConcurrentExecutions?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisionedConcurrencyConfigArgs].
 */
@PulumiTagMarker
public class ProvisionedConcurrencyConfigArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var provisionedConcurrentExecutions: Output<Int>? = null

    private var qualifier: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function.
     */
    @JvmName("yyfpsvnlvutubmxl")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Amount of capacity to allocate. Must be greater than or equal to `1`.
     */
    @JvmName("xhwmcsfkkiwxxcfp")
    public suspend fun provisionedConcurrentExecutions(`value`: Output<Int>) {
        this.provisionedConcurrentExecutions = value
    }

    /**
     * @param value Lambda Function version or Lambda Alias name.
     * The following arguments are optional:
     */
    @JvmName("tuuldxmlwjeltpst")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
     */
    @JvmName("btogwfxpaassvaju")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function.
     */
    @JvmName("fnjybukelnhitnas")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Amount of capacity to allocate. Must be greater than or equal to `1`.
     */
    @JvmName("vsidrbgemtsiywrm")
    public suspend fun provisionedConcurrentExecutions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedConcurrentExecutions = mapped
    }

    /**
     * @param value Lambda Function version or Lambda Alias name.
     * The following arguments are optional:
     */
    @JvmName("fdfohaceuhgkesly")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
     */
    @JvmName("bdgayqvglxaiupuo")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    internal fun build(): ProvisionedConcurrencyConfigArgs = ProvisionedConcurrencyConfigArgs(
        functionName = functionName,
        provisionedConcurrentExecutions = provisionedConcurrentExecutions,
        qualifier = qualifier,
        skipDestroy = skipDestroy,
    )
}
