@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RuntimeManagementConfig].
 */
@PulumiTagMarker
public class RuntimeManagementConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuntimeManagementConfigArgs = RuntimeManagementConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuntimeManagementConfigArgsBuilder.() -> Unit) {
        val builder = RuntimeManagementConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RuntimeManagementConfig {
        val builtJavaResource = com.pulumi.aws.lambda.RuntimeManagementConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuntimeManagementConfig(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lambda Runtime Management Config.
 * Refer to the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) for supported runtimes.
 * > Deletion of this resource returns the runtime update mode to `Auto` (the default behavior).
 * To leave the configured runtime management options in-place, use a `removed` block with the destroy lifecycle set to `false`.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.RuntimeManagementConfig("example", {
 *     functionName: test.functionName,
 *     updateRuntimeOn: "FunctionUpdate",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.RuntimeManagementConfig("example",
 *     function_name=test["functionName"],
 *     update_runtime_on="FunctionUpdate")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.RuntimeManagementConfig("example", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         UpdateRuntimeOn = "FunctionUpdate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewRuntimeManagementConfig(ctx, "example", &lambda.RuntimeManagementConfigArgs{
 * 			FunctionName:    pulumi.Any(test.FunctionName),
 * 			UpdateRuntimeOn: pulumi.String("FunctionUpdate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.RuntimeManagementConfig;
 * import com.pulumi.aws.lambda.RuntimeManagementConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuntimeManagementConfig("example", RuntimeManagementConfigArgs.builder()
 *             .functionName(test.functionName())
 *             .updateRuntimeOn("FunctionUpdate")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:RuntimeManagementConfig
 *     properties:
 *       functionName: ${test.functionName}
 *       updateRuntimeOn: FunctionUpdate
 * ```
 * <!--End PulumiCodeChooser -->
 * ### `Manual` Update
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.RuntimeManagementConfig("example", {
 *     functionName: test.functionName,
 *     updateRuntimeOn: "Manual",
 *     runtimeVersionArn: "arn:aws:lambda:us-east-1::runtime:abcd1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.RuntimeManagementConfig("example",
 *     function_name=test["functionName"],
 *     update_runtime_on="Manual",
 *     runtime_version_arn="arn:aws:lambda:us-east-1::runtime:abcd1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.RuntimeManagementConfig("example", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         UpdateRuntimeOn = "Manual",
 *         RuntimeVersionArn = "arn:aws:lambda:us-east-1::runtime:abcd1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewRuntimeManagementConfig(ctx, "example", &lambda.RuntimeManagementConfigArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			UpdateRuntimeOn:   pulumi.String("Manual"),
 * 			RuntimeVersionArn: pulumi.String("arn:aws:lambda:us-east-1::runtime:abcd1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.RuntimeManagementConfig;
 * import com.pulumi.aws.lambda.RuntimeManagementConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuntimeManagementConfig("example", RuntimeManagementConfigArgs.builder()
 *             .functionName(test.functionName())
 *             .updateRuntimeOn("Manual")
 *             .runtimeVersionArn("arn:aws:lambda:us-east-1::runtime:abcd1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:RuntimeManagementConfig
 *     properties:
 *       functionName: ${test.functionName}
 *       updateRuntimeOn: Manual
 *       runtimeVersionArn: arn:aws:lambda:us-east-1::runtime:abcd1234
 * ```
 * <!--End PulumiCodeChooser -->
 * > Once the runtime update mode is set to `Manual`, the `aws.lambda.Function` `runtime` cannot be updated. To upgrade a runtime, the `update_runtime_on` argument must be set to `Auto` or `FunctionUpdate` prior to changing the function's `runtime` argument.
 * ## Import
 * Using `pulumi import`, import Lambda Runtime Management Config using a comma-delimited string combining `function_name` and `qualifier`. For example:
 * ```sh
 * $ pulumi import aws:lambda/runtimeManagementConfig:RuntimeManagementConfig example my-function,$LATEST
 * ```
 */
public class RuntimeManagementConfig internal constructor(
    override val javaResource: com.pulumi.aws.lambda.RuntimeManagementConfig,
) : KotlinCustomResource(javaResource, RuntimeManagementConfigMapper) {
    /**
     * ARN of the function.
     */
    public val functionArn: Output<String>
        get() = javaResource.functionArn().applyValue({ args0 -> args0 })

    /**
     * Name or ARN of the Lambda function.
     * The following arguments are optional:
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
     */
    public val qualifier: Output<String>?
        get() = javaResource.qualifier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
     */
    public val runtimeVersionArn: Output<String>?
        get() = javaResource.runtimeVersionArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
     */
    public val updateRuntimeOn: Output<String>?
        get() = javaResource.updateRuntimeOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RuntimeManagementConfigMapper : ResourceMapper<RuntimeManagementConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.RuntimeManagementConfig::class == javaResource::class

    override fun map(javaResource: Resource): RuntimeManagementConfig =
        RuntimeManagementConfig(javaResource as com.pulumi.aws.lambda.RuntimeManagementConfig)
}

/**
 * @see [RuntimeManagementConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuntimeManagementConfig].
 */
public suspend fun runtimeManagementConfig(
    name: String,
    block: suspend RuntimeManagementConfigResourceBuilder.() -> Unit,
): RuntimeManagementConfig {
    val builder = RuntimeManagementConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuntimeManagementConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun runtimeManagementConfig(name: String): RuntimeManagementConfig {
    val builder = RuntimeManagementConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
