@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.RuntimeManagementConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lambda Runtime Management Config.
 * Refer to the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) for supported runtimes.
 * > Deletion of this resource returns the runtime update mode to `Auto` (the default behavior).
 * To leave the configured runtime management options in-place, use a `removed` block with the destroy lifecycle set to `false`.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.RuntimeManagementConfig("example", {
 *     functionName: test.functionName,
 *     updateRuntimeOn: "FunctionUpdate",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.RuntimeManagementConfig("example",
 *     function_name=test["functionName"],
 *     update_runtime_on="FunctionUpdate")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.RuntimeManagementConfig("example", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         UpdateRuntimeOn = "FunctionUpdate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewRuntimeManagementConfig(ctx, "example", &lambda.RuntimeManagementConfigArgs{
 * 			FunctionName:    pulumi.Any(test.FunctionName),
 * 			UpdateRuntimeOn: pulumi.String("FunctionUpdate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.RuntimeManagementConfig;
 * import com.pulumi.aws.lambda.RuntimeManagementConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuntimeManagementConfig("example", RuntimeManagementConfigArgs.builder()
 *             .functionName(test.functionName())
 *             .updateRuntimeOn("FunctionUpdate")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:RuntimeManagementConfig
 *     properties:
 *       functionName: ${test.functionName}
 *       updateRuntimeOn: FunctionUpdate
 * ```
 * <!--End PulumiCodeChooser -->
 * ### `Manual` Update
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.RuntimeManagementConfig("example", {
 *     functionName: test.functionName,
 *     updateRuntimeOn: "Manual",
 *     runtimeVersionArn: "arn:aws:lambda:us-east-1::runtime:abcd1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.RuntimeManagementConfig("example",
 *     function_name=test["functionName"],
 *     update_runtime_on="Manual",
 *     runtime_version_arn="arn:aws:lambda:us-east-1::runtime:abcd1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.RuntimeManagementConfig("example", new()
 *     {
 *         FunctionName = test.FunctionName,
 *         UpdateRuntimeOn = "Manual",
 *         RuntimeVersionArn = "arn:aws:lambda:us-east-1::runtime:abcd1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lambda.NewRuntimeManagementConfig(ctx, "example", &lambda.RuntimeManagementConfigArgs{
 * 			FunctionName:      pulumi.Any(test.FunctionName),
 * 			UpdateRuntimeOn:   pulumi.String("Manual"),
 * 			RuntimeVersionArn: pulumi.String("arn:aws:lambda:us-east-1::runtime:abcd1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.RuntimeManagementConfig;
 * import com.pulumi.aws.lambda.RuntimeManagementConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuntimeManagementConfig("example", RuntimeManagementConfigArgs.builder()
 *             .functionName(test.functionName())
 *             .updateRuntimeOn("Manual")
 *             .runtimeVersionArn("arn:aws:lambda:us-east-1::runtime:abcd1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:RuntimeManagementConfig
 *     properties:
 *       functionName: ${test.functionName}
 *       updateRuntimeOn: Manual
 *       runtimeVersionArn: arn:aws:lambda:us-east-1::runtime:abcd1234
 * ```
 * <!--End PulumiCodeChooser -->
 * > Once the runtime update mode is set to `Manual`, the `aws.lambda.Function` `runtime` cannot be updated. To upgrade a runtime, the `update_runtime_on` argument must be set to `Auto` or `FunctionUpdate` prior to changing the function's `runtime` argument.
 * ## Import
 * Using `pulumi import`, import Lambda Runtime Management Config using a comma-delimited string combining `function_name` and `qualifier`. For example:
 * ```sh
 * $ pulumi import aws:lambda/runtimeManagementConfig:RuntimeManagementConfig example my-function,$LATEST
 * ```
 * @property functionName Name or ARN of the Lambda function.
 * The following arguments are optional:
 * @property qualifier Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
 * @property runtimeVersionArn ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
 * @property updateRuntimeOn Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
 */
public data class RuntimeManagementConfigArgs(
    public val functionName: Output<String>? = null,
    public val qualifier: Output<String>? = null,
    public val runtimeVersionArn: Output<String>? = null,
    public val updateRuntimeOn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.RuntimeManagementConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.RuntimeManagementConfigArgs =
        com.pulumi.aws.lambda.RuntimeManagementConfigArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .runtimeVersionArn(runtimeVersionArn?.applyValue({ args0 -> args0 }))
            .updateRuntimeOn(updateRuntimeOn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuntimeManagementConfigArgs].
 */
@PulumiTagMarker
public class RuntimeManagementConfigArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var runtimeVersionArn: Output<String>? = null

    private var updateRuntimeOn: Output<String>? = null

    /**
     * @param value Name or ARN of the Lambda function.
     * The following arguments are optional:
     */
    @JvmName("vxhfocchdtkewoou")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
     */
    @JvmName("kfmalpaaiochnwid")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
     */
    @JvmName("gmqoometvipysnul")
    public suspend fun runtimeVersionArn(`value`: Output<String>) {
        this.runtimeVersionArn = value
    }

    /**
     * @param value Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
     */
    @JvmName("nsjvugltmlqwjrni")
    public suspend fun updateRuntimeOn(`value`: Output<String>) {
        this.updateRuntimeOn = value
    }

    /**
     * @param value Name or ARN of the Lambda function.
     * The following arguments are optional:
     */
    @JvmName("qxvowycotgjliphf")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
     */
    @JvmName("gwfuyuhsvqulpcoq")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
     */
    @JvmName("ecxpcgsaxcnhxbxd")
    public suspend fun runtimeVersionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersionArn = mapped
    }

    /**
     * @param value Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
     */
    @JvmName("niyxkfxonpemorll")
    public suspend fun updateRuntimeOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateRuntimeOn = mapped
    }

    internal fun build(): RuntimeManagementConfigArgs = RuntimeManagementConfigArgs(
        functionName = functionName,
        qualifier = qualifier,
        runtimeVersionArn = runtimeVersionArn,
        updateRuntimeOn = updateRuntimeOn,
    )
}
