@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * See https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html
 */
public enum class Runtime(
    public val javaValue: com.pulumi.aws.lambda.enums.Runtime,
) : ConvertibleToJava<com.pulumi.aws.lambda.enums.Runtime> {
    Dotnet6(com.pulumi.aws.lambda.enums.Runtime.Dotnet6),
    Dotnet7(com.pulumi.aws.lambda.enums.Runtime.Dotnet7),
    Dotnet8(com.pulumi.aws.lambda.enums.Runtime.Dotnet8),
    Java11(com.pulumi.aws.lambda.enums.Runtime.Java11),
    Java17(com.pulumi.aws.lambda.enums.Runtime.Java17),
    Java21(com.pulumi.aws.lambda.enums.Runtime.Java21),
    Java8AL2(com.pulumi.aws.lambda.enums.Runtime.Java8AL2),
    NodeJS18dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS18dX),
    NodeJS20dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS20dX),
    CustomAL2(com.pulumi.aws.lambda.enums.Runtime.CustomAL2),
    CustomAL2023(com.pulumi.aws.lambda.enums.Runtime.CustomAL2023),
    Python3d10(com.pulumi.aws.lambda.enums.Runtime.Python3d10),
    Python3d11(com.pulumi.aws.lambda.enums.Runtime.Python3d11),
    Python3d12(com.pulumi.aws.lambda.enums.Runtime.Python3d12),
    Python3d8(com.pulumi.aws.lambda.enums.Runtime.Python3d8),
    Python3d9(com.pulumi.aws.lambda.enums.Runtime.Python3d9),
    Ruby3d2(com.pulumi.aws.lambda.enums.Runtime.Ruby3d2),
    Dotnet5d0(com.pulumi.aws.lambda.enums.Runtime.Dotnet5d0),
    DotnetCore2d1(com.pulumi.aws.lambda.enums.Runtime.DotnetCore2d1),
    DotnetCore3d1(com.pulumi.aws.lambda.enums.Runtime.DotnetCore3d1),
    Go1dx(com.pulumi.aws.lambda.enums.Runtime.Go1dx),
    Java8(com.pulumi.aws.lambda.enums.Runtime.Java8),
    NodeJS10dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS10dX),
    NodeJS12dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS12dX),
    NodeJS14dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS14dX),
    NodeJS16dX(com.pulumi.aws.lambda.enums.Runtime.NodeJS16dX),
    Custom(com.pulumi.aws.lambda.enums.Runtime.Custom),
    Python2d7(com.pulumi.aws.lambda.enums.Runtime.Python2d7),
    Python3d6(com.pulumi.aws.lambda.enums.Runtime.Python3d6),
    Python3d7(com.pulumi.aws.lambda.enums.Runtime.Python3d7),
    Ruby2d5(com.pulumi.aws.lambda.enums.Runtime.Ruby2d5),
    Ruby2d7(com.pulumi.aws.lambda.enums.Runtime.Ruby2d7),
    ;

    override fun toJava(): com.pulumi.aws.lambda.enums.Runtime = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.enums.Runtime): Runtime =
            Runtime.values().first { it.javaValue == javaType }
    }
}
