@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property signingProfileVersionArns The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
 */
public data class CodeSigningConfigAllowedPublishersArgs(
    public val signingProfileVersionArns: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs =
        com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs.builder()
            .signingProfileVersionArns(
                signingProfileVersionArns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [CodeSigningConfigAllowedPublishersArgs].
 */
@PulumiTagMarker
public class CodeSigningConfigAllowedPublishersArgsBuilder internal constructor() {
    private var signingProfileVersionArns: Output<List<String>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
     */
    @JvmName("tdyobvotqkefersv")
    public suspend fun signingProfileVersionArns(`value`: Output<List<String>>) {
        this.signingProfileVersionArns = value
    }

    @JvmName("ftjhmctmsusdfnta")
    public suspend fun signingProfileVersionArns(vararg values: Output<String>) {
        this.signingProfileVersionArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
     */
    @JvmName("cqojrebrdgpgecea")
    public suspend fun signingProfileVersionArns(values: List<Output<String>>) {
        this.signingProfileVersionArns = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
     */
    @JvmName("sjggondcuwurmksm")
    public suspend fun signingProfileVersionArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingProfileVersionArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
     */
    @JvmName("niaaweyeboihlpib")
    public suspend fun signingProfileVersionArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingProfileVersionArns = mapped
    }

    internal fun build(): CodeSigningConfigAllowedPublishersArgs =
        CodeSigningConfigAllowedPublishersArgs(
            signingProfileVersionArns = signingProfileVersionArns ?: throw
                PulumiNullFieldException("signingProfileVersionArns"),
        )
}
