@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consumerGroupId A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
 */
public data class EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs(
    public val consumerGroupId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs.builder()
            .consumerGroupId(consumerGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsBuilder internal constructor() {
    private var consumerGroupId: Output<String>? = null

    /**
     * @param value A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
     */
    @JvmName("bebimufbqwxdxygk")
    public suspend fun consumerGroupId(`value`: Output<String>) {
        this.consumerGroupId = value
    }

    /**
     * @param value A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
     */
    @JvmName("xfgiuwbtvonvpnkn")
    public suspend fun consumerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupId = mapped
    }

    internal fun build(): EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs =
        EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs(
            consumerGroupId = consumerGroupId,
        )
}
