@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigOnFailureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationArn The Amazon Resource Name (ARN) of the destination resource.
 */
public data class EventSourceMappingDestinationConfigOnFailureArgs(
    public val destinationArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigOnFailureArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigOnFailureArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigOnFailureArgs.builder()
            .destinationArn(destinationArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingDestinationConfigOnFailureArgs].
 */
@PulumiTagMarker
public class EventSourceMappingDestinationConfigOnFailureArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the destination resource.
     */
    @JvmName("plffgwljqepacbby")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the destination resource.
     */
    @JvmName("oiuuvmqwvswscdeq")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    internal fun build(): EventSourceMappingDestinationConfigOnFailureArgs =
        EventSourceMappingDestinationConfigOnFailureArgs(
            destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        )
}
