@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumConcurrency Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to `2`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/with-sqs&#46;html#events-sqs-max-concurrency)&#46; You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
 */
public data class EventSourceMappingScalingConfigArgs(
    public val maximumConcurrency: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs.builder()
            .maximumConcurrency(maximumConcurrency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingScalingConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingScalingConfigArgsBuilder internal constructor() {
    private var maximumConcurrency: Output<Int>? = null

    /**
     * @param value Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to `2`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/with-sqs&#46;html#events-sqs-max-concurrency)&#46; You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
     */
    @JvmName("wvdskcpnrawvqpwa")
    public suspend fun maximumConcurrency(`value`: Output<Int>) {
        this.maximumConcurrency = value
    }

    /**
     * @param value Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to `2`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/with-sqs&#46;html#events-sqs-max-concurrency)&#46; You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
     */
    @JvmName("awvhwrlrlknokwgj")
    public suspend fun maximumConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumConcurrency = mapped
    }

    internal fun build(): EventSourceMappingScalingConfigArgs = EventSourceMappingScalingConfigArgs(
        maximumConcurrency = maximumConcurrency,
    )
}
