@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property endpoints A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
 */
public data class EventSourceMappingSelfManagedEventSourceArgs(
    public val endpoints: Output<Map<String, String>>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs.builder()
            .endpoints(
                endpoints.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSourceMappingSelfManagedEventSourceArgs].
 */
@PulumiTagMarker
public class EventSourceMappingSelfManagedEventSourceArgsBuilder internal constructor() {
    private var endpoints: Output<Map<String, String>>? = null

    /**
     * @param value A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
     */
    @JvmName("yvnvsyohffmoyobs")
    public suspend fun endpoints(`value`: Output<Map<String, String>>) {
        this.endpoints = value
    }

    /**
     * @param value A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
     */
    @JvmName("yqfqocftfqdddceo")
    public suspend fun endpoints(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param values A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
     */
    @JvmName("gxqdqoiajrasvpng")
    public fun endpoints(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    internal fun build(): EventSourceMappingSelfManagedEventSourceArgs =
        EventSourceMappingSelfManagedEventSourceArgs(
            endpoints = endpoints ?: throw PulumiNullFieldException("endpoints"),
        )
}
