@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionDeadLetterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetArn ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
 */
public data class FunctionDeadLetterConfigArgs(
    public val targetArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionDeadLetterConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionDeadLetterConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionDeadLetterConfigArgs.builder()
            .targetArn(targetArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionDeadLetterConfigArgs].
 */
@PulumiTagMarker
public class FunctionDeadLetterConfigArgsBuilder internal constructor() {
    private var targetArn: Output<String>? = null

    /**
     * @param value ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
     */
    @JvmName("rcokeeuiripoxqss")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
     */
    @JvmName("ycouasxhxixrnkpc")
    public suspend fun targetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): FunctionDeadLetterConfigArgs = FunctionDeadLetterConfigArgs(
        targetArn = targetArn ?: throw PulumiNullFieldException("targetArn"),
    )
}
