@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property variables Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
 */
public data class FunctionEnvironmentArgs(
    public val variables: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs =
        com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs.builder()
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FunctionEnvironmentArgs].
 */
@PulumiTagMarker
public class FunctionEnvironmentArgsBuilder internal constructor() {
    private var variables: Output<Map<String, String>>? = null

    /**
     * @param value Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
     */
    @JvmName("srnmdruhxvwomifv")
    public suspend fun variables(`value`: Output<Map<String, String>>) {
        this.variables = value
    }

    /**
     * @param value Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
     */
    @JvmName("xqrwdrolgllgjeuk")
    public suspend fun variables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
     */
    @JvmName("mplglivpcwlejghc")
    public fun variables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): FunctionEnvironmentArgs = FunctionEnvironmentArgs(
        variables = variables,
    )
}
