@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure Configuration block with destination configuration for failed asynchronous invocations. See below for details.
 * @property onSuccess Configuration block with destination configuration for successful asynchronous invocations. See below for details.
 */
public data class FunctionEventInvokeConfigDestinationConfigArgs(
    public val onFailure: Output<FunctionEventInvokeConfigDestinationConfigOnFailureArgs>? = null,
    public val onSuccess: Output<FunctionEventInvokeConfigDestinationConfigOnSuccessArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs = com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs.builder()
        .onFailure(onFailure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .onSuccess(onSuccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FunctionEventInvokeConfigDestinationConfigArgs].
 */
@PulumiTagMarker
public class FunctionEventInvokeConfigDestinationConfigArgsBuilder internal constructor() {
    private var onFailure: Output<FunctionEventInvokeConfigDestinationConfigOnFailureArgs>? = null

    private var onSuccess: Output<FunctionEventInvokeConfigDestinationConfigOnSuccessArgs>? = null

    /**
     * @param value Configuration block with destination configuration for failed asynchronous invocations. See below for details.
     */
    @JvmName("gbwawrlvghnvbogb")
    public suspend fun onFailure(`value`: Output<FunctionEventInvokeConfigDestinationConfigOnFailureArgs>) {
        this.onFailure = value
    }

    /**
     * @param value Configuration block with destination configuration for successful asynchronous invocations. See below for details.
     */
    @JvmName("gxwevdtrgetbvcan")
    public suspend fun onSuccess(`value`: Output<FunctionEventInvokeConfigDestinationConfigOnSuccessArgs>) {
        this.onSuccess = value
    }

    /**
     * @param value Configuration block with destination configuration for failed asynchronous invocations. See below for details.
     */
    @JvmName("xbsmhfyugvtvntoc")
    public suspend fun onFailure(`value`: FunctionEventInvokeConfigDestinationConfigOnFailureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param argument Configuration block with destination configuration for failed asynchronous invocations. See below for details.
     */
    @JvmName("mtfkhpdfiycgybob")
    public suspend fun onFailure(argument: suspend FunctionEventInvokeConfigDestinationConfigOnFailureArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionEventInvokeConfigDestinationConfigOnFailureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onFailure = mapped
    }

    /**
     * @param value Configuration block with destination configuration for successful asynchronous invocations. See below for details.
     */
    @JvmName("jtllvqlpmavwxxxl")
    public suspend fun onSuccess(`value`: FunctionEventInvokeConfigDestinationConfigOnSuccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onSuccess = mapped
    }

    /**
     * @param argument Configuration block with destination configuration for successful asynchronous invocations. See below for details.
     */
    @JvmName("nfhbtqjpgvfjsske")
    public suspend fun onSuccess(argument: suspend FunctionEventInvokeConfigDestinationConfigOnSuccessArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionEventInvokeConfigDestinationConfigOnSuccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onSuccess = mapped
    }

    internal fun build(): FunctionEventInvokeConfigDestinationConfigArgs =
        FunctionEventInvokeConfigDestinationConfigArgs(
            onFailure = onFailure,
            onSuccess = onSuccess,
        )
}
