@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
 */
public data class FunctionEventInvokeConfigDestinationConfigOnSuccessArgs(
    public val destination: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs =
        com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionEventInvokeConfigDestinationConfigOnSuccessArgs].
 */
@PulumiTagMarker
public class FunctionEventInvokeConfigDestinationConfigOnSuccessArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
     */
    @JvmName("jfscavwnpwvrpewp")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
     */
    @JvmName("scdvkhoomtuheumf")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    internal fun build(): FunctionEventInvokeConfigDestinationConfigOnSuccessArgs =
        FunctionEventInvokeConfigDestinationConfigOnSuccessArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
        )
}
