@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionLoggingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationLogLevel for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
 * @property logFormat select between `Text` and structured `JSON` format for your function's logs.
 * @property logGroup the CloudWatch log group your function sends logs to.
 * @property systemLogLevel for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
 */
public data class FunctionLoggingConfigArgs(
    public val applicationLogLevel: Output<String>? = null,
    public val logFormat: Output<String>,
    public val logGroup: Output<String>? = null,
    public val systemLogLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionLoggingConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionLoggingConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionLoggingConfigArgs.builder()
            .applicationLogLevel(applicationLogLevel?.applyValue({ args0 -> args0 }))
            .logFormat(logFormat.applyValue({ args0 -> args0 }))
            .logGroup(logGroup?.applyValue({ args0 -> args0 }))
            .systemLogLevel(systemLogLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionLoggingConfigArgs].
 */
@PulumiTagMarker
public class FunctionLoggingConfigArgsBuilder internal constructor() {
    private var applicationLogLevel: Output<String>? = null

    private var logFormat: Output<String>? = null

    private var logGroup: Output<String>? = null

    private var systemLogLevel: Output<String>? = null

    /**
     * @param value for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
     */
    @JvmName("mabxjwrymkpihbli")
    public suspend fun applicationLogLevel(`value`: Output<String>) {
        this.applicationLogLevel = value
    }

    /**
     * @param value select between `Text` and structured `JSON` format for your function's logs.
     */
    @JvmName("jlyhxfeqaofjtnrs")
    public suspend fun logFormat(`value`: Output<String>) {
        this.logFormat = value
    }

    /**
     * @param value the CloudWatch log group your function sends logs to.
     */
    @JvmName("tkahifarbyyslpvv")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
     */
    @JvmName("wpunwlhextmxghbm")
    public suspend fun systemLogLevel(`value`: Output<String>) {
        this.systemLogLevel = value
    }

    /**
     * @param value for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
     */
    @JvmName("aapehnnufoevdfod")
    public suspend fun applicationLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationLogLevel = mapped
    }

    /**
     * @param value select between `Text` and structured `JSON` format for your function's logs.
     */
    @JvmName("pakrventnrnnvmqh")
    public suspend fun logFormat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logFormat = mapped
    }

    /**
     * @param value the CloudWatch log group your function sends logs to.
     */
    @JvmName("hwljbsftujyypbum")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    /**
     * @param value for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
     */
    @JvmName("wneasiaiskrejsqr")
    public suspend fun systemLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemLogLevel = mapped
    }

    internal fun build(): FunctionLoggingConfigArgs = FunctionLoggingConfigArgs(
        applicationLogLevel = applicationLogLevel,
        logFormat = logFormat ?: throw PulumiNullFieldException("logFormat"),
        logGroup = logGroup,
        systemLogLevel = systemLogLevel,
    )
}
