@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionSnapStartArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applyOn Conditions where snap start is enabled. Valid values are `PublishedVersions`.
 * @property optimizationStatus Optimization status of the snap start configuration. Valid values are `On` and `Off`.
 */
public data class FunctionSnapStartArgs(
    public val applyOn: Output<String>,
    public val optimizationStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionSnapStartArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionSnapStartArgs =
        com.pulumi.aws.lambda.inputs.FunctionSnapStartArgs.builder()
            .applyOn(applyOn.applyValue({ args0 -> args0 }))
            .optimizationStatus(optimizationStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionSnapStartArgs].
 */
@PulumiTagMarker
public class FunctionSnapStartArgsBuilder internal constructor() {
    private var applyOn: Output<String>? = null

    private var optimizationStatus: Output<String>? = null

    /**
     * @param value Conditions where snap start is enabled. Valid values are `PublishedVersions`.
     */
    @JvmName("hiiayyndgdqytyyi")
    public suspend fun applyOn(`value`: Output<String>) {
        this.applyOn = value
    }

    /**
     * @param value Optimization status of the snap start configuration. Valid values are `On` and `Off`.
     */
    @JvmName("fhbmrrvilsmosuee")
    public suspend fun optimizationStatus(`value`: Output<String>) {
        this.optimizationStatus = value
    }

    /**
     * @param value Conditions where snap start is enabled. Valid values are `PublishedVersions`.
     */
    @JvmName("ilwsgvmbdqdrrtob")
    public suspend fun applyOn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyOn = mapped
    }

    /**
     * @param value Optimization status of the snap start configuration. Valid values are `On` and `Off`.
     */
    @JvmName("cmvbwgjggfxtkhus")
    public suspend fun optimizationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizationStatus = mapped
    }

    internal fun build(): FunctionSnapStartArgs = FunctionSnapStartArgs(
        applyOn = applyOn ?: throw PulumiNullFieldException("applyOn"),
        optimizationStatus = optimizationStatus,
    )
}
