@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionTracingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Whether to sample and trace a subset of incoming requests with AWS X-Ray. Valid values are `PassThrough` and `Active`. If `PassThrough`, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If `Active`, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.
 */
public data class FunctionTracingConfigArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionTracingConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionTracingConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionTracingConfigArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionTracingConfigArgs].
 */
@PulumiTagMarker
public class FunctionTracingConfigArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Whether to sample and trace a subset of incoming requests with AWS X-Ray. Valid values are `PassThrough` and `Active`. If `PassThrough`, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If `Active`, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.
     */
    @JvmName("aqydrdllhphpkyrx")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Whether to sample and trace a subset of incoming requests with AWS X-Ray. Valid values are `PassThrough` and `Active`. If `PassThrough`, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If `Active`, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.
     */
    @JvmName("tcjljdvjkmrdkofp")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): FunctionTracingConfigArgs = FunctionTracingConfigArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
