@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlias.
 * @property functionName Name of the aliased Lambda function.
 * @property name Name of the Lambda alias.
 */
public data class GetAliasPlainArgs(
    public val functionName: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetAliasPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetAliasPlainArgs =
        com.pulumi.aws.lambda.inputs.GetAliasPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAliasPlainArgs].
 */
@PulumiTagMarker
public class GetAliasPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var name: String? = null

    /**
     * @param value Name of the aliased Lambda function.
     */
    @JvmName("pordilokdydhrpaf")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Name of the Lambda alias.
     */
    @JvmName("aetytyxbsalxpkfw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetAliasPlainArgs = GetAliasPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
