@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetCodeSigningConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCodeSigningConfig.
 * @property arn ARN of the code signing configuration.
 */
public data class GetCodeSigningConfigPlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetCodeSigningConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetCodeSigningConfigPlainArgs =
        com.pulumi.aws.lambda.inputs.GetCodeSigningConfigPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCodeSigningConfigPlainArgs].
 */
@PulumiTagMarker
public class GetCodeSigningConfigPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value ARN of the code signing configuration.
     */
    @JvmName("vokqquwxyugkdjql")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetCodeSigningConfigPlainArgs = GetCodeSigningConfigPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
