@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFunction.
 * @property functionName Name of the lambda function.
 * @property qualifier Alias name or version number of the lambda functionE.g., `$LATEST`, `my-alias`, or `1`. When not included: the data source resolves to the most recent published version; if no published version exists: it resolves to the most recent unpublished version.
 * @property tags
 */
public data class GetFunctionPlainArgs(
    public val functionName: String,
    public val qualifier: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetFunctionPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetFunctionPlainArgs =
        com.pulumi.aws.lambda.inputs.GetFunctionPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .qualifier(qualifier?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetFunctionPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var qualifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the lambda function.
     */
    @JvmName("rspqhxvfubrphitr")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Alias name or version number of the lambda functionE.g., `$LATEST`, `my-alias`, or `1`. When not included: the data source resolves to the most recent published version; if no published version exists: it resolves to the most recent unpublished version.
     */
    @JvmName("sulqejxmukjwywen")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.qualifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("pkilcacssssfpadl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hqfxxdntxedpjynl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetFunctionPlainArgs = GetFunctionPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        qualifier = qualifier,
        tags = tags,
    )
}
