@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetInvocationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInvocation.
 * @property functionName Name of the lambda function.
 * @property input String in JSON format that is passed as payload to the lambda function.
 * @property qualifier Qualifier (a.k.a version) of the lambda function. Defaults
 * to `$LATEST`.
 */
public data class GetInvocationPlainArgs(
    public val functionName: String,
    public val input: String,
    public val qualifier: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetInvocationPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetInvocationPlainArgs =
        com.pulumi.aws.lambda.inputs.GetInvocationPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .input(input.let({ args0 -> args0 }))
            .qualifier(qualifier?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInvocationPlainArgs].
 */
@PulumiTagMarker
public class GetInvocationPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var input: String? = null

    private var qualifier: String? = null

    /**
     * @param value Name of the lambda function.
     */
    @JvmName("lfiseumoqvgnkstg")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value String in JSON format that is passed as payload to the lambda function.
     */
    @JvmName("qfdktqjmqndnqock")
    public suspend fun input(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.input = mapped
    }

    /**
     * @param value Qualifier (a.k.a version) of the lambda function. Defaults
     * to `$LATEST`.
     */
    @JvmName("vhepkmttmaitinmt")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.qualifier = mapped
    }

    internal fun build(): GetInvocationPlainArgs = GetInvocationPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        input = input ?: throw PulumiNullFieldException("input"),
        qualifier = qualifier,
    )
}
