@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.GetLayerVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLayerVersion.
 * @property compatibleArchitecture Specific architecture the layer version could support. Conflicts with `version`. If specified, the latest available layer version supporting the provided architecture will be used.
 * @property compatibleRuntime Specific runtime the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided runtime will be used.
 * @property layerName Name of the lambda layer.
 * @property version Specific layer version. Conflicts with `compatible_runtime` and `compatible_architecture`. If omitted, the latest available layer version will be used.
 */
public data class GetLayerVersionPlainArgs(
    public val compatibleArchitecture: String? = null,
    public val compatibleRuntime: String? = null,
    public val layerName: String,
    public val version: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.GetLayerVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.GetLayerVersionPlainArgs =
        com.pulumi.aws.lambda.inputs.GetLayerVersionPlainArgs.builder()
            .compatibleArchitecture(compatibleArchitecture?.let({ args0 -> args0 }))
            .compatibleRuntime(compatibleRuntime?.let({ args0 -> args0 }))
            .layerName(layerName.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLayerVersionPlainArgs].
 */
@PulumiTagMarker
public class GetLayerVersionPlainArgsBuilder internal constructor() {
    private var compatibleArchitecture: String? = null

    private var compatibleRuntime: String? = null

    private var layerName: String? = null

    private var version: Int? = null

    /**
     * @param value Specific architecture the layer version could support. Conflicts with `version`. If specified, the latest available layer version supporting the provided architecture will be used.
     */
    @JvmName("aaxreghjqhnbgxri")
    public suspend fun compatibleArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.compatibleArchitecture = mapped
    }

    /**
     * @param value Specific runtime the layer version must support. Conflicts with `version`. If specified, the latest available layer version supporting the provided runtime will be used.
     */
    @JvmName("lxqexeclybfblguy")
    public suspend fun compatibleRuntime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.compatibleRuntime = mapped
    }

    /**
     * @param value Name of the lambda layer.
     */
    @JvmName("vjqcpcygmhpmqbme")
    public suspend fun layerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.layerName = mapped
    }

    /**
     * @param value Specific layer version. Conflicts with `compatible_runtime` and `compatible_architecture`. If omitted, the latest available layer version will be used.
     */
    @JvmName("xkdoqpmekbbjsqwl")
    public suspend fun version(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetLayerVersionPlainArgs = GetLayerVersionPlainArgs(
        compatibleArchitecture = compatibleArchitecture,
        compatibleRuntime = compatibleRuntime,
        layerName = layerName ?: throw PulumiNullFieldException("layerName"),
        version = version,
    )
}
