@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property additionalVersionWeights A map that defines the proportion of events that should be sent to different versions of a lambda function.
 */
public data class AliasRoutingConfig(
    public val additionalVersionWeights: Map<String, Double>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.AliasRoutingConfig): AliasRoutingConfig = AliasRoutingConfig(
            additionalVersionWeights = javaType.additionalVersionWeights().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
