@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property untrustedArtifactOnDeployment Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
 */
public data class CodeSigningConfigPolicies(
    public val untrustedArtifactOnDeployment: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.CodeSigningConfigPolicies): CodeSigningConfigPolicies = CodeSigningConfigPolicies(
            untrustedArtifactOnDeployment = javaType.untrustedArtifactOnDeployment(),
        )
    }
}
