@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumConcurrency Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to `2`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/with-sqs&#46;html#events-sqs-max-concurrency)&#46; You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
 */
public data class EventSourceMappingScalingConfig(
    public val maximumConcurrency: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingScalingConfig): EventSourceMappingScalingConfig = EventSourceMappingScalingConfig(
            maximumConcurrency = javaType.maximumConcurrency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
