@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property endpoints A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
 */
public data class EventSourceMappingSelfManagedEventSource(
    public val endpoints: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingSelfManagedEventSource): EventSourceMappingSelfManagedEventSource = EventSourceMappingSelfManagedEventSource(
            endpoints = javaType.endpoints().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
