@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type of authentication protocol, VPC components, or virtual host for your event source. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/api/API_SourceAccessConfiguration.html).
 * @property uri The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an aws.ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an aws.ec2.SecurityGroup resource's id attribute.
 */
public data class EventSourceMappingSourceAccessConfiguration(
    public val type: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.EventSourceMappingSourceAccessConfiguration): EventSourceMappingSourceAccessConfiguration = EventSourceMappingSourceAccessConfiguration(
            type = javaType.type(),
            uri = javaType.uri(),
        )
    }
}
