@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property targetArn ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
 */
public data class FunctionDeadLetterConfig(
    public val targetArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionDeadLetterConfig): FunctionDeadLetterConfig = FunctionDeadLetterConfig(
            targetArn = javaType.targetArn(),
        )
    }
}
