@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property size The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
 */
public data class FunctionEphemeralStorage(
    public val size: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionEphemeralStorage): FunctionEphemeralStorage = FunctionEphemeralStorage(
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
