@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property onFailure Configuration block with destination configuration for failed asynchronous invocations. See below for details.
 * @property onSuccess Configuration block with destination configuration for successful asynchronous invocations. See below for details.
 */
public data class FunctionEventInvokeConfigDestinationConfig(
    public val onFailure: FunctionEventInvokeConfigDestinationConfigOnFailure? = null,
    public val onSuccess: FunctionEventInvokeConfigDestinationConfigOnSuccess? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionEventInvokeConfigDestinationConfig): FunctionEventInvokeConfigDestinationConfig = FunctionEventInvokeConfigDestinationConfig(
            onFailure = javaType.onFailure().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.FunctionEventInvokeConfigDestinationConfigOnFailure.Companion.toKotlin(args0)
                })
            }).orElse(null),
            onSuccess = javaType.onSuccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.FunctionEventInvokeConfigDestinationConfigOnSuccess.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
