@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationLogLevel for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
 * @property logFormat select between `Text` and structured `JSON` format for your function's logs.
 * @property logGroup the CloudWatch log group your function sends logs to.
 * @property systemLogLevel for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
 */
public data class FunctionLoggingConfig(
    public val applicationLogLevel: String? = null,
    public val logFormat: String,
    public val logGroup: String? = null,
    public val systemLogLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionLoggingConfig): FunctionLoggingConfig = FunctionLoggingConfig(
            applicationLogLevel = javaType.applicationLogLevel().map({ args0 -> args0 }).orElse(null),
            logFormat = javaType.logFormat(),
            logGroup = javaType.logGroup().map({ args0 -> args0 }).orElse(null),
            systemLogLevel = javaType.systemLogLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
