@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipv6AllowedForDualStack Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
 * @property securityGroupIds List of security group IDs associated with the Lambda function.
 * @property subnetIds List of subnet IDs associated with the Lambda function.
 * @property vpcId ID of the VPC.
 */
public data class FunctionVpcConfig(
    public val ipv6AllowedForDualStack: Boolean? = null,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.FunctionVpcConfig): FunctionVpcConfig = FunctionVpcConfig(
            ipv6AllowedForDualStack = javaType.ipv6AllowedForDualStack().map({ args0 -> args0 }).orElse(null),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
