@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAlias.
 * @property arn ARN identifying the Lambda function alias.
 * @property description Description of alias.
 * @property functionName
 * @property functionVersion Lambda function version which the alias uses.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property invokeArn ARN to be used for invoking Lambda Function from API Gateway - to be used in aws_api_gateway_integration's `uri`.
 * @property name
 */
public data class GetAliasResult(
    public val arn: String,
    public val description: String,
    public val functionName: String,
    public val functionVersion: String,
    public val id: String,
    public val invokeArn: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetAliasResult): GetAliasResult =
            GetAliasResult(
                arn = javaType.arn(),
                description = javaType.description(),
                functionName = javaType.functionName(),
                functionVersion = javaType.functionVersion(),
                id = javaType.id(),
                invokeArn = javaType.invokeArn(),
                name = javaType.name(),
            )
    }
}
