@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFunction.
 * @property architectures Instruction set architecture for the Lambda function.
 * @property arn Unqualified (no `:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `qualified_arn`.
 * @property codeSha256 Base64-encoded representation of raw SHA-256 sum of the zip file.
 * @property codeSigningConfigArn ARN for a Code Signing Configuration.
 * @property deadLetterConfig Configure the function's *dead letter queue*.
 * @property description Description of what your Lambda Function does.
 * @property environment Lambda environment's configuration settings.
 * @property ephemeralStorages Amount of Ephemeral storage(`/tmp`) allocated for the Lambda Function.
 * @property fileSystemConfigs Connection settings for an Amazon EFS file system.
 * @property functionName
 * @property handler Function entrypoint in your code.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageUri URI of the container image.
 * @property invokeArn ARN to be used for invoking Lambda Function from API Gateway. **NOTE:** Starting with `v4.51.0` of the provider, this will *not* include the qualifier.
 * @property kmsKeyArn ARN for the KMS encryption key.
 * @property lastModified Date this resource was last modified.
 * @property layers List of Lambda Layer ARNs attached to your Lambda Function.
 * @property loggingConfigs Advanced logging settings.
 * @property memorySize Amount of memory in MB your Lambda Function can use at runtime.
 * @property qualifiedArn Qualified (`:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `arn`.
 * @property qualifiedInvokeArn Qualified (`:QUALIFIER` or `:VERSION` suffix) ARN to be used for invoking Lambda Function from API Gateway. See also `invoke_arn`.
 * @property qualifier
 * @property reservedConcurrentExecutions The amount of reserved concurrent executions for this lambda function or `-1` if unreserved.
 * @property role IAM role attached to the Lambda Function.
 * @property runtime Runtime environment for the Lambda function.
 * @property signingJobArn ARN of a signing job.
 * @property signingProfileVersionArn The ARN for a signing profile version.
 * @property sourceCodeHash (**Deprecated** use `code_sha256` instead) Base64-encoded representation of raw SHA-256 sum of the zip file.
 * @property sourceCodeSize Size in bytes of the function .zip file.
 * @property tags
 * @property timeout Function execution time at which Lambda should terminate the function.
 * @property tracingConfig Tracing settings of the function.
 * @property version The version of the Lambda function returned. If `qualifier` is not set, this will resolve to the most recent published version. If no published version of the function exists, `version` will resolve to `$LATEST`.
 * @property vpcConfig VPC configuration associated with your Lambda function.
 */
public data class GetFunctionResult(
    public val architectures: List<String>,
    public val arn: String,
    public val codeSha256: String,
    public val codeSigningConfigArn: String,
    public val deadLetterConfig: GetFunctionDeadLetterConfig,
    public val description: String,
    public val environment: GetFunctionEnvironment,
    public val ephemeralStorages: List<GetFunctionEphemeralStorage>,
    public val fileSystemConfigs: List<GetFunctionFileSystemConfig>,
    public val functionName: String,
    public val handler: String,
    public val id: String,
    public val imageUri: String,
    public val invokeArn: String,
    public val kmsKeyArn: String,
    public val lastModified: String,
    public val layers: List<String>,
    public val loggingConfigs: List<GetFunctionLoggingConfig>,
    public val memorySize: Int,
    public val qualifiedArn: String,
    public val qualifiedInvokeArn: String,
    public val qualifier: String? = null,
    public val reservedConcurrentExecutions: Int,
    public val role: String,
    public val runtime: String,
    public val signingJobArn: String,
    public val signingProfileVersionArn: String,
    @Deprecated(
        message = """
  This attribute is deprecated and will be removed in a future major version. Use `code_sha256`
      instead.
  """,
    )
    public val sourceCodeHash: String,
    public val sourceCodeSize: Int,
    public val tags: Map<String, String>,
    public val timeout: Int,
    public val tracingConfig: GetFunctionTracingConfig,
    public val version: String,
    public val vpcConfig: GetFunctionVpcConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionResult): GetFunctionResult = GetFunctionResult(
            architectures = javaType.architectures().map({ args0 -> args0 }),
            arn = javaType.arn(),
            codeSha256 = javaType.codeSha256(),
            codeSigningConfigArn = javaType.codeSigningConfigArn(),
            deadLetterConfig = javaType.deadLetterConfig().let({ args0 ->
                com.pulumi.aws.lambda.kotlin.outputs.GetFunctionDeadLetterConfig.Companion.toKotlin(args0)
            }),
            description = javaType.description(),
            environment = javaType.environment().let({ args0 ->
                com.pulumi.aws.lambda.kotlin.outputs.GetFunctionEnvironment.Companion.toKotlin(args0)
            }),
            ephemeralStorages = javaType.ephemeralStorages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetFunctionEphemeralStorage.Companion.toKotlin(args0)
                })
            }),
            fileSystemConfigs = javaType.fileSystemConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetFunctionFileSystemConfig.Companion.toKotlin(args0)
                })
            }),
            functionName = javaType.functionName(),
            handler = javaType.handler(),
            id = javaType.id(),
            imageUri = javaType.imageUri(),
            invokeArn = javaType.invokeArn(),
            kmsKeyArn = javaType.kmsKeyArn(),
            lastModified = javaType.lastModified(),
            layers = javaType.layers().map({ args0 -> args0 }),
            loggingConfigs = javaType.loggingConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetFunctionLoggingConfig.Companion.toKotlin(args0)
                })
            }),
            memorySize = javaType.memorySize(),
            qualifiedArn = javaType.qualifiedArn(),
            qualifiedInvokeArn = javaType.qualifiedInvokeArn(),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            reservedConcurrentExecutions = javaType.reservedConcurrentExecutions(),
            role = javaType.role(),
            runtime = javaType.runtime(),
            signingJobArn = javaType.signingJobArn(),
            signingProfileVersionArn = javaType.signingProfileVersionArn(),
            sourceCodeHash = javaType.sourceCodeHash(),
            sourceCodeSize = javaType.sourceCodeSize(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeout = javaType.timeout(),
            tracingConfig = javaType.tracingConfig().let({ args0 ->
                com.pulumi.aws.lambda.kotlin.outputs.GetFunctionTracingConfig.Companion.toKotlin(args0)
            }),
            version = javaType.version(),
            vpcConfig = javaType.vpcConfig().let({ args0 ->
                com.pulumi.aws.lambda.kotlin.outputs.GetFunctionVpcConfig.Companion.toKotlin(args0)
            }),
        )
    }
}
