@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowCredentials
 * @property allowHeaders
 * @property allowMethods
 * @property allowOrigins
 * @property exposeHeaders
 * @property maxAge
 */
public data class GetFunctionUrlCor(
    public val allowCredentials: Boolean,
    public val allowHeaders: List<String>,
    public val allowMethods: List<String>,
    public val allowOrigins: List<String>,
    public val exposeHeaders: List<String>,
    public val maxAge: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionUrlCor): GetFunctionUrlCor = GetFunctionUrlCor(
            allowCredentials = javaType.allowCredentials(),
            allowHeaders = javaType.allowHeaders().map({ args0 -> args0 }),
            allowMethods = javaType.allowMethods().map({ args0 -> args0 }),
            allowOrigins = javaType.allowOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAge = javaType.maxAge(),
        )
    }
}
