@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFunctionUrl.
 * @property authorizationType Type of authentication that the function URL uses.
 * @property cors The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. See the `aws.lambda.FunctionUrl` resource documentation for more details.
 * @property creationTime When the function URL was created, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime).
 * @property functionArn ARN of the function.
 * @property functionName
 * @property functionUrl HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property invokeMode Whether the Lambda function responds in `BUFFERED` or `RESPONSE_STREAM` mode.
 * @property lastModifiedTime When the function URL configuration was last updated, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime).
 * @property qualifier
 * @property urlId Generated ID for the endpoint.
 */
public data class GetFunctionUrlResult(
    public val authorizationType: String,
    public val cors: List<GetFunctionUrlCor>,
    public val creationTime: String,
    public val functionArn: String,
    public val functionName: String,
    public val functionUrl: String,
    public val id: String,
    public val invokeMode: String,
    public val lastModifiedTime: String,
    public val qualifier: String? = null,
    public val urlId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionUrlResult): GetFunctionUrlResult = GetFunctionUrlResult(
            authorizationType = javaType.authorizationType(),
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lambda.kotlin.outputs.GetFunctionUrlCor.Companion.toKotlin(args0)
                })
            }),
            creationTime = javaType.creationTime(),
            functionArn = javaType.functionArn(),
            functionName = javaType.functionName(),
            functionUrl = javaType.functionUrl(),
            id = javaType.id(),
            invokeMode = javaType.invokeMode(),
            lastModifiedTime = javaType.lastModifiedTime(),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            urlId = javaType.urlId(),
        )
    }
}
