@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipv6AllowedForDualStack
 * @property securityGroupIds
 * @property subnetIds
 * @property vpcId
 */
public data class GetFunctionVpcConfig(
    public val ipv6AllowedForDualStack: Boolean,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetFunctionVpcConfig): GetFunctionVpcConfig = GetFunctionVpcConfig(
            ipv6AllowedForDualStack = javaType.ipv6AllowedForDualStack(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
