@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getInvocation.
 * @property functionName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property input
 * @property qualifier
 * @property result String result of the lambda function invocation.
 */
public data class GetInvocationResult(
    public val functionName: String,
    public val id: String,
    public val input: String,
    public val qualifier: String? = null,
    public val result: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lambda.outputs.GetInvocationResult): GetInvocationResult = GetInvocationResult(
            functionName = javaType.functionName(),
            id = javaType.id(),
            input = javaType.input(),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            result = javaType.result(),
        )
    }
}
