@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.LbFunctions.getHostedZoneIdPlain
import com.pulumi.aws.lb.LbFunctions.getLbsPlain
import com.pulumi.aws.lb.LbFunctions.getListenerPlain
import com.pulumi.aws.lb.LbFunctions.getLoadBalancerPlain
import com.pulumi.aws.lb.LbFunctions.getTargetGroupPlain
import com.pulumi.aws.lb.LbFunctions.getTrustStorePlain
import com.pulumi.aws.lb.kotlin.inputs.GetHostedZoneIdPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetHostedZoneIdPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetLbsPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetLbsPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetListenerPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetListenerPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetLoadBalancerPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetLoadBalancerPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetTargetGroupPlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetTargetGroupPlainArgsBuilder
import com.pulumi.aws.lb.kotlin.inputs.GetTrustStorePlainArgs
import com.pulumi.aws.lb.kotlin.inputs.GetTrustStorePlainArgsBuilder
import com.pulumi.aws.lb.kotlin.outputs.GetHostedZoneIdResult
import com.pulumi.aws.lb.kotlin.outputs.GetLbsResult
import com.pulumi.aws.lb.kotlin.outputs.GetListenerResult
import com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerResult
import com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupResult
import com.pulumi.aws.lb.kotlin.outputs.GetTrustStoreResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.lb.kotlin.outputs.GetHostedZoneIdResult.Companion.toKotlin as getHostedZoneIdResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetLbsResult.Companion.toKotlin as getLbsResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetListenerResult.Companion.toKotlin as getListenerResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerResult.Companion.toKotlin as getLoadBalancerResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetTargetGroupResult.Companion.toKotlin as getTargetGroupResultToKotlin
import com.pulumi.aws.lb.kotlin.outputs.GetTrustStoreResult.Companion.toKotlin as getTrustStoreResultToKotlin

public object LbFunctions {
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.lb.getHostedZoneId({});
     * const www = new aws.route53.Record("www", {
     *     zoneId: primary.zoneId,
     *     name: "example.com",
     *     type: aws.route53.RecordType.A,
     *     aliases: [{
     *         name: mainAwsLb.dnsName,
     *         zoneId: main.then(main => main.id),
     *         evaluateTargetHealth: true,
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.lb.get_hosted_zone_id()
     * www = aws.route53.Record("www",
     *     zone_id=primary["zoneId"],
     *     name="example.com",
     *     type=aws.route53.RecordType.A,
     *     aliases=[{
     *         "name": main_aws_lb["dnsName"],
     *         "zone_id": main.id,
     *         "evaluate_target_health": True,
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.LB.GetHostedZoneId.Invoke();
     *     var www = new Aws.Route53.Record("www", new()
     *     {
     *         ZoneId = primary.ZoneId,
     *         Name = "example.com",
     *         Type = Aws.Route53.RecordType.A,
     *         Aliases = new[]
     *         {
     *             new Aws.Route53.Inputs.RecordAliasArgs
     *             {
     *                 Name = mainAwsLb.DnsName,
     *                 ZoneId = main.Apply(getHostedZoneIdResult => getHostedZoneIdResult.Id),
     *                 EvaluateTargetHealth = true,
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		main, err := lb.GetHostedZoneId(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = route53.NewRecord(ctx, "www", &route53.RecordArgs{
     * 			ZoneId: pulumi.Any(primary.ZoneId),
     * 			Name:   pulumi.String("example.com"),
     * 			Type:   pulumi.String(route53.RecordTypeA),
     * 			Aliases: route53.RecordAliasArray{
     * 				&route53.RecordAliasArgs{
     * 					Name:                 pulumi.Any(mainAwsLb.DnsName),
     * 					ZoneId:               pulumi.String(main.Id),
     * 					EvaluateTargetHealth: pulumi.Bool(true),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     *         var www = new Record("www", RecordArgs.builder()
     *             .zoneId(primary.zoneId())
     *             .name("example.com")
     *             .type("A")
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(mainAwsLb.dnsName())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -> getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   www:
     *     type: aws:route53:Record
     *     properties:
     *       zoneId: ${primary.zoneId}
     *       name: example.com
     *       type: A
     *       aliases:
     *         - name: ${mainAwsLb.dnsName}
     *           zoneId: ${main.id}
     *           evaluateTargetHealth: true
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:lb:getHostedZoneId
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHostedZoneId.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: GetHostedZoneIdPlainArgs): GetHostedZoneIdResult =
        getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())

    /**
     * @see [getHostedZoneId].
     * @param loadBalancerType Type of load balancer to create. Possible values are `application` or `network`. The default value is `application`.
     * @param region Name of the region whose AWS ELB HostedZoneId is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(loadBalancerType: String? = null, region: String? = null): GetHostedZoneIdResult {
        val argument = GetHostedZoneIdPlainArgs(
            loadBalancerType = loadBalancerType,
            region = region,
        )
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostedZoneId].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetHostedZoneIdPlainArgs].
     * @return A collection of values returned by getHostedZoneId.
     */
    public suspend fun getHostedZoneId(argument: suspend GetHostedZoneIdPlainArgsBuilder.() -> Unit): GetHostedZoneIdResult {
        val builder = GetHostedZoneIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostedZoneIdResultToKotlin(getHostedZoneIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.lb.getLbs({
     *     tags: {
     *         "elbv2.k8s.aws/cluster": "my-cluster",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.lb.get_lbs(tags={
     *     "elbv2.k8s.aws/cluster": "my-cluster",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.LB.GetLbs.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "elbv2.k8s.aws/cluster", "my-cluster" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lb.GetLbs(ctx, &lb.GetLbsArgs{
     * 			Tags: map[string]interface{}{
     * 				"elbv2.k8s.aws/cluster": "my-cluster",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of("elbv2.k8s.aws/cluster", "my-cluster"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:lb:getLbs
     *       Arguments:
     *         tags:
     *           elbv2.k8s.aws/cluster: my-cluster
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLbs.
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(argument: GetLbsPlainArgs): GetLbsResult =
        getLbsResultToKotlin(getLbsPlain(argument.toJava()).await())

    /**
     * @see [getLbs].
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired Load Balancers.
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(tags: Map<String, String>? = null): GetLbsResult {
        val argument = GetLbsPlainArgs(
            tags = tags,
        )
        return getLbsResultToKotlin(getLbsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLbs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetLbsPlainArgs].
     * @return A collection of values returned by getLbs.
     */
    public suspend fun getLbs(argument: suspend GetLbsPlainArgsBuilder.() -> Unit): GetLbsResult {
        val builder = GetLbsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLbsResultToKotlin(getLbsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * Provides information about a Load Balancer Listener.
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const listenerArn = config.require("listenerArn");
     * const listener = aws.lb.getListener({
     *     arn: listenerArn,
     * });
     * // get listener from load_balancer_arn and port
     * const selected = aws.lb.getLoadBalancer({
     *     name: "default-public",
     * });
     * const selected443 = selected.then(selected => aws.lb.getListener({
     *     loadBalancerArn: selected.arn,
     *     port: 443,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * listener_arn = config.require("listenerArn")
     * listener = aws.lb.get_listener(arn=listener_arn)
     * # get listener from load_balancer_arn and port
     * selected = aws.lb.get_load_balancer(name="default-public")
     * selected443 = aws.lb.get_listener(load_balancer_arn=selected.arn,
     *     port=443)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var listenerArn = config.Require("listenerArn");
     *     var listener = Aws.LB.GetListener.Invoke(new()
     *     {
     *         Arn = listenerArn,
     *     });
     *     // get listener from load_balancer_arn and port
     *     var selected = Aws.LB.GetLoadBalancer.Invoke(new()
     *     {
     *         Name = "default-public",
     *     });
     *     var selected443 = Aws.LB.GetListener.Invoke(new()
     *     {
     *         LoadBalancerArn = selected.Apply(getLoadBalancerResult => getLoadBalancerResult.Arn),
     *         Port = 443,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		listenerArn := cfg.Require("listenerArn")
     * 		_, err := lb.LookupListener(ctx, &lb.LookupListenerArgs{
     * 			Arn: pulumi.StringRef(listenerArn),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// get listener from load_balancer_arn and port
     * 		selected, err := lb.LookupLoadBalancer(ctx, &lb.LookupLoadBalancerArgs{
     * 			Name: pulumi.StringRef("default-public"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = lb.LookupListener(ctx, &lb.LookupListenerArgs{
     * 			LoadBalancerArn: pulumi.StringRef(selected.Arn),
     * 			Port:            pulumi.IntRef(443),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get("listenerArn");
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     *         // get listener from load_balancer_arn and port
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name("default-public")
     *             .build());
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -> getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   # get listener from listener arn
     *   listenerArn:
     *     type: string
     * variables:
     *   listener:
     *     fn::invoke:
     *       Function: aws:lb:getListener
     *       Arguments:
     *         arn: ${listenerArn}
     *   # get listener from load_balancer_arn and port
     *   selected:
     *     fn::invoke:
     *       Function: aws:lb:getLoadBalancer
     *       Arguments:
     *         name: default-public
     *   selected443:
     *     fn::invoke:
     *       Function: aws:lb:getListener
     *       Arguments:
     *         loadBalancerArn: ${selected.arn}
     *         port: 443
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getListener.
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: GetListenerPlainArgs): GetListenerResult =
        getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())

    /**
     * @see [getListener].
     * @param arn ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
     * @param loadBalancerArn ARN of the load balancer. Required if `arn` is not set.
     * @param port Port of the listener. Required if `arn` is not set.
     * @param tags
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(
        arn: String? = null,
        loadBalancerArn: String? = null,
        port: Int? = null,
        tags: Map<String, String>? = null,
    ): GetListenerResult {
        val argument = GetListenerPlainArgs(
            arn = arn,
            loadBalancerArn = loadBalancerArn,
            port = port,
            tags = tags,
        )
        return getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getListener].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetListenerPlainArgs].
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: suspend GetListenerPlainArgsBuilder.() -> Unit): GetListenerResult {
        val builder = GetListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenerResultToKotlin(getListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * Provides information about a Load Balancer.
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const lbArn = config.get("lbArn") || "";
     * const lbName = config.get("lbName") || "";
     * const test = aws.lb.getLoadBalancer({
     *     arn: lbArn,
     *     name: lbName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * lb_arn = config.get("lbArn")
     * if lb_arn is None:
     *     lb_arn = ""
     * lb_name = config.get("lbName")
     * if lb_name is None:
     *     lb_name = ""
     * test = aws.lb.get_load_balancer(arn=lb_arn,
     *     name=lb_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var lbArn = config.Get("lbArn") ?? "";
     *     var lbName = config.Get("lbName") ?? "";
     *     var test = Aws.LB.GetLoadBalancer.Invoke(new()
     *     {
     *         Arn = lbArn,
     *         Name = lbName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		lbArn := ""
     * 		if param := cfg.Get("lbArn"); param != "" {
     * 			lbArn = param
     * 		}
     * 		lbName := ""
     * 		if param := cfg.Get("lbName"); param != "" {
     * 			lbName = param
     * 		}
     * 		_, err := lb.LookupLoadBalancer(ctx, &lb.LookupLoadBalancerArgs{
     * 			Arn:  pulumi.StringRef(lbArn),
     * 			Name: pulumi.StringRef(lbName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get("lbArn").orElse("");
     *         final var lbName = config.get("lbName").orElse("");
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   lbArn:
     *     type: string
     *     default:
     *   lbName:
     *     type: string
     *     default:
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lb:getLoadBalancer
     *       Arguments:
     *         arn: ${lbArn}
     *         name: ${lbName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLoadBalancer.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: GetLoadBalancerPlainArgs): GetLoadBalancerResult =
        getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancer].
     * @param arn Full ARN of the load balancer.
     * @param name Unique name of the load balancer.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetLoadBalancerResult {
        val argument = GetLoadBalancerPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetLoadBalancerPlainArgs].
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: suspend GetLoadBalancerPlainArgsBuilder.() -> Unit): GetLoadBalancerResult {
        val builder = GetLoadBalancerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * Provides information about a Load Balancer Target Group.
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const lbTgArn = config.get("lbTgArn") || "";
     * const lbTgName = config.get("lbTgName") || "";
     * const test = aws.lb.getTargetGroup({
     *     arn: lbTgArn,
     *     name: lbTgName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * lb_tg_arn = config.get("lbTgArn")
     * if lb_tg_arn is None:
     *     lb_tg_arn = ""
     * lb_tg_name = config.get("lbTgName")
     * if lb_tg_name is None:
     *     lb_tg_name = ""
     * test = aws.lb.get_target_group(arn=lb_tg_arn,
     *     name=lb_tg_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var lbTgArn = config.Get("lbTgArn") ?? "";
     *     var lbTgName = config.Get("lbTgName") ?? "";
     *     var test = Aws.LB.GetTargetGroup.Invoke(new()
     *     {
     *         Arn = lbTgArn,
     *         Name = lbTgName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		lbTgArn := ""
     * 		if param := cfg.Get("lbTgArn"); param != "" {
     * 			lbTgArn = param
     * 		}
     * 		lbTgName := ""
     * 		if param := cfg.Get("lbTgName"); param != "" {
     * 			lbTgName = param
     * 		}
     * 		_, err := lb.LookupTargetGroup(ctx, &lb.LookupTargetGroupArgs{
     * 			Arn:  pulumi.StringRef(lbTgArn),
     * 			Name: pulumi.StringRef(lbTgName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get("lbTgArn").orElse("");
     *         final var lbTgName = config.get("lbTgName").orElse("");
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   lbTgArn:
     *     type: string
     *     default:
     *   lbTgName:
     *     type: string
     *     default:
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lb:getTargetGroup
     *       Arguments:
     *         arn: ${lbTgArn}
     *         name: ${lbTgName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTargetGroup.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: GetTargetGroupPlainArgs): GetTargetGroupResult =
        getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())

    /**
     * @see [getTargetGroup].
     * @param arn Full ARN of the target group.
     * @param loadBalancingAnomalyMitigation
     * @param name Unique name of the target group.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired target group.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has the lowest precedence.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(
        arn: String? = null,
        loadBalancingAnomalyMitigation: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetTargetGroupResult {
        val argument = GetTargetGroupPlainArgs(
            arn = arn,
            loadBalancingAnomalyMitigation = loadBalancingAnomalyMitigation,
            name = name,
            tags = tags,
        )
        return getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getTargetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetTargetGroupPlainArgs].
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: suspend GetTargetGroupPlainArgsBuilder.() -> Unit): GetTargetGroupResult {
        val builder = GetTargetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetGroupResultToKotlin(getTargetGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws_alb_trust_store` is known as `aws.lb.TrustStore`. The functionality is identical.
     * Provides information about a Load Balancer Trust Store.
     * This data source can prove useful when a module accepts an LB Trust Store as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Trust Store for use in other resources, given LB Trust Store name.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const lbTsArn = config.get("lbTsArn") || "";
     * const lbTsName = config.get("lbTsName") || "";
     * const test = aws.lb.getTrustStore({
     *     arn: lbTsArn,
     *     name: lbTsName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * lb_ts_arn = config.get("lbTsArn")
     * if lb_ts_arn is None:
     *     lb_ts_arn = ""
     * lb_ts_name = config.get("lbTsName")
     * if lb_ts_name is None:
     *     lb_ts_name = ""
     * test = aws.lb.get_trust_store(arn=lb_ts_arn,
     *     name=lb_ts_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var lbTsArn = config.Get("lbTsArn") ?? "";
     *     var lbTsName = config.Get("lbTsName") ?? "";
     *     var test = Aws.LB.GetTrustStore.Invoke(new()
     *     {
     *         Arn = lbTsArn,
     *         Name = lbTsName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		lbTsArn := ""
     * 		if param := cfg.Get("lbTsArn"); param != "" {
     * 			lbTsArn = param
     * 		}
     * 		lbTsName := ""
     * 		if param := cfg.Get("lbTsName"); param != "" {
     * 			lbTsName = param
     * 		}
     * 		_, err := lb.LookupTrustStore(ctx, &lb.LookupTrustStoreArgs{
     * 			Arn:  pulumi.StringRef(lbTsArn),
     * 			Name: pulumi.StringRef(lbTsName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTrustStoreArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTsArn = config.get("lbTsArn").orElse("");
     *         final var lbTsName = config.get("lbTsName").orElse("");
     *         final var test = LbFunctions.getTrustStore(GetTrustStoreArgs.builder()
     *             .arn(lbTsArn)
     *             .name(lbTsName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   lbTsArn:
     *     type: string
     *     default:
     *   lbTsName:
     *     type: string
     *     default:
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lb:getTrustStore
     *       Arguments:
     *         arn: ${lbTsArn}
     *         name: ${lbTsName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrustStore.
     * @return A collection of values returned by getTrustStore.
     */
    public suspend fun getTrustStore(argument: GetTrustStorePlainArgs): GetTrustStoreResult =
        getTrustStoreResultToKotlin(getTrustStorePlain(argument.toJava()).await())

    /**
     * @see [getTrustStore].
     * @param arn Full ARN of the trust store.
     * @param name Unique name of the trust store.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @return A collection of values returned by getTrustStore.
     */
    public suspend fun getTrustStore(arn: String? = null, name: String? = null): GetTrustStoreResult {
        val argument = GetTrustStorePlainArgs(
            arn = arn,
            name = name,
        )
        return getTrustStoreResultToKotlin(getTrustStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getTrustStore].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lb&#46;kotlin&#46;inputs&#46;GetTrustStorePlainArgs].
     * @return A collection of values returned by getTrustStore.
     */
    public suspend fun getTrustStore(argument: suspend GetTrustStorePlainArgsBuilder.() -> Unit): GetTrustStoreResult {
        val builder = GetTrustStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrustStoreResultToKotlin(getTrustStorePlain(builtArgument.toJava()).await())
    }
}
